/*

This file contains definitions relating to message passing between
the CM manager and user.

Following is the structure of a message.  Unfortunately, this is illegal
because "number" is variable as well as the sizeof(slot).  This structure
will be built dynamically when necessary and discarded after the message
has been used (read or written).  In order to make it legal, we will leave
comment out the "slot" field and read/write that by hand.  This hack will
be used throughout the message code.  Yuck.

*/

struct msg {
	int version;		/* version of cmm system */
	int size;		/* size of msg structure itself */
	int slots;			/* number of slots */
	char name[CM_PROCESSNAMELENGTH];
	char read_wait;		/* TRUE, if sender waiting for an acknowledgement */
	struct slot data[1];	/* really want [0] */
} ;

/*

Each message is composed of a header.  The header includes the process name,
number of slots, and the slots themselves.

*/


