/* cm_interface.h - interface to common memory
Definitions of types used in the handshaking package
*/

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define or		||
#define and		&&
#define OR		||
#define AND		&&

#ifndef BOOLEAN
#define BOOLEAN
typedef int boolean;
#endif

#define ANY_STATUS		0

/* definitions for command associations */
typedef int cm_command_association;
#define cm_set_command_association(cmd,assoc) \
		cmd->command_association = (assoc)
#define cm_get_command_association(cmd,assoc) \
		((assoc) = cmd->command_association)
/* was		((*(assoc)) = cmd->command_association) */
extern cm_command_association input_command_association;

#define var_in_use(v)	(v->inuse)

struct usr_var_role {
		unsigned reader : 1;
		unsigned nonxwriter : 1;
		unsigned xwriter : 1;
		unsigned wakeup : 1;
};

typedef struct {
	char name[CM_VARIABLENAMELENGTH];
	cm_value data;	/* actual user data */
	struct usr_var_role role;
	unsigned long old_count;	/* when last read */
	unsigned long count;		/* nth definition of this var */
					/* zero means "never been written" */

					/* the following are tags noting: */
	int old_command_association;	/* when last read */
	int command_association;	/* unique identifier tieing this to a
					   single command and multiple
					   statii */
	struct timeval timestamp;	/* when this data was written */
	/* the following is not transmitted to the cmm */
	struct {
		unsigned declared	: 1;
		unsigned written 	: 1;
		unsigned inuse		: 1;
		unsigned undeclared	: 1;
	} status;
} cm_variable, cm_command_variable, cm_status_variable;

/* the following definitions are correctly eaten by the C compiler */
cm_value *cm_get_value();
void cm_set_value();
boolean cm_get_new_command_value();
void cm_set_new_command_value();
boolean cm_new_command_pendingp();
/* if these remain as macros, the C preprocessor no longer cares for */
/* these lines */
/*cm_command_association cm_get_command_association();*/
/*cm_set_command_association cm_command_association();*/
boolean cm_status_equal();
boolean cm_status_synchronizedp();
void cm_set_status_value();
cm_variable *cm_declare();
cm_variable *next_user_variable();

#define cm_command_association int

/*	
Functions used in the handshaking package

This is a list of definitions that includes arguments which the current C
compilers do not care for.

cm_get_value(cm_variable,cm_value)
cm_set_value(cm_variable,cm_value)
boolean cm_get_new_command_value(cm_variable,value)
cm_set_new_command_value(cm_variable,value)
boolean cm_new_command_pending?(cm_variable)
cm_command_association cm_get_command_association(cm_variable,
	command_association)
cm_set_command_association cm_command_association(cm_variable,
	command_association)
boolean cm_status_equal(command_variable,status_variable,status_value)
boolean cm_status_synchronized(command_variable,status_variable)
cm_set_status_value(status_variable,cm_value)

*/

