/*
This process, b, writes a string to variable b_var.
It then checks variable a_var for a new value, and if it is, prints it.
It then sleeps for 5 seconds.
*/
#include <sys/time.h>
#include "cm.h"

#define BUFFER_LENGTH	1000
char b_data[BUFFER_LENGTH];

cm_value a_val = {0,0,0,1}, b_val = {b_data,BUFFER_LENGTH,0,0};

main()
{
	cm_variable *a_var, *b_var;
	int seqno = 0;

	if (0> cm_init("b",0,0)) exit(-1);

	if (!(a_var = cm_declare("a_var",CM_ROLE_READER|CM_ROLE_WAKEUP)))
		exit(-1);
	if (!(b_var = cm_declare("b_var",CM_ROLE_NONXWRITER)))
		exit(-1);

	for (;;) {
		sprintf(b_data,"Message from b.  seq #%d",seqno++);
		b_val.size = strlen(b_data) + 1;
		cm_set_value(b_var,&b_val);
		cm_sync(CM_NO_WAIT);
		if (cm_get_new_value(a_var,&a_val))
			printf("a_var: %s\n",a_val.data);
		sleep(5);
	}
}

