/*

These are the Lisp covering functions for the common memory system.

They are:

int Lcm_init(process_name,host,debug_level)
void Lcm_exit()
cm_variable *Lcm_declare(name,role)
void Lcm_undeclare(var)
int Lcm_sync(wait)
void Lcm_set_value(var,val)
void Lcm_get_value(var,val)
int Lcm_set_new_command_value(command_out,command_value)
int Lcm_new_command_pending(input_command)
int Lcm_get_new_command_value(input_command,cm_value)
int Lcm_status_equal(command_out,status_in,status_value)
int Lcm_status_synchronized(command_out,status_in)
void cm_set_status_value(status_out,status_value)
void Lcm_print_variable(name)
*/

#include <stdio.h>
#include <sys/time.h>
#include "global.h"	/* comes from /usr/local/include/franz */
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_var.h"
#include "cm_interface.h"

#define MAXSTRLEN	1500	/* ugh */

lispval
Lcm_init(name,host,debug_level)
char *name;
char *host;
int *debug_level;
{
	return(inewint(cm_init(name,host,*debug_level)));
}

void
Lcm_exit()
{
	cm_exit();
}

cm_variable *
Lcm_declare(name,role)
char *name;
long int *role;
{
	cm_variable *p;

	p = cm_declare(name,(unsigned)*role);
	eprintf(10,"cm_declare() = %x\n",p);
	return(p);
}

void
Lcm_undeclare(var)
int *var;
{
	cm_undeclare(*var);
}

int
Lcm_sync(wait)
long int *wait;
{
	return(cm_sync((int)*wait));
}

void
Lcm_set_value(var,val)
int *var;
lispval val;		/* was union structured_data **val; */
{
/*
printf("entering Lcm_set_value\n"); fflush(stdout);
printf("value is <%s>\n",(char *)val); fflush(stdout);
printf("var is %x\n",var); fflush(stdout);
printf("*var is %x\n",*var); fflush(stdout);
printf("**var is %x\n",*(int *)*var); fflush(stdout);
*/
	cm_set_value(*var,(char *)val);
}

/* note this new version will not correctly return anything but 
structured_data objects!!! */
void
Lcm_get_value(var,val)
cm_variable **var;
lispval val;
{
	cm_get_value(*var,(char *)val);
}

int
Lcm_set_new_command_value(var,val)
cm_variable **var;
union structured_data **val;
{
	cm_set_new_command_value(*var,*val);
}

int
Lcm_new_command_pending(cmd)
cm_command_variable *cmd;
{
	return(cm_new_command_pending(*cmd));
}

int
Lcm_get_new_command_value(cmd,val)
cm_command_variable *cmd;
union structured_data **val;
{
	return(cm_get_new_command_value(*cmd,*val));
}

int
Lcm_status_equal(cmd,status_in,status_val)
cm_command_variable *cmd;
cm_status_variable **status_in;
union structured_data **status_val;
{
	return(cm_status_equal(*cmd,*status_in,*status_val));
}

int
Lcm_status_synchronized(command_out,status_in)
cm_command_variable *command_out;
cm_status_variable **status_in;
{
	return(cm_status_synchronized(*command_out,*status_in));
}

void
Lcm_set_status_value(command_in,status_out,status_value)
cm_command_variable **command_in;
cm_status_variable **status_out;
union structured_data **status_value;
{
	cm_set_status_value(*command_in,*status_out,*status_value);
}

void
Lcm_print_variable(name)
char *name;
{
	cm_print_variable(name);
}
