/*

These routines build slots for the cmm.  These slots are placed into a
msg structure and sent to the user.

*/

#include <stdio.h>
#include <sys/time.h>
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_slot.h"	/* definitions of slot structures */
#include "cm_bytestuff.h"

extern struct msg *omsg;	/* this is soooo... messy */

put_slot_read_response(m,name,count,timestamp,cmd,data)
struct msg *m;
char *name;
unsigned long count;
struct timeval *timestamp;
int cmd;
cm_value *data;
{
	struct big_slot s;
	unsigned int size;

	init_slot(&s,name,CM_SLOT_READ_RESPONSE);
	size = align(sizeof(struct slot_hdr));
	size += align(sizeof(struct slot_read_response_hdr));
	s.subslot.read_response.srr_count = count;
	cm_time_copy(timestamp,&s.subslot.read_response.srr_timestamp);
	s.subslot.read_response.srr_command_association = cmd;
	size += cm_sd_to_flat(data,&s.subslot.read_response.fdata);
	finish_slot(m,&s,size);
}

/* error slots should never be generated by the user since infinite loops */
/* could result between the user and cmm sending each other back error slots */
put_slot_error(m,name,type,string)
struct msg *m;
char *name;
int type;
char *string;
{
	struct big_slot s;
	unsigned int size;

	fprintf(stdout,"slot error in <%s>  type %d - %s\n",name,type,string);
	
	init_slot(&s,name,CM_SLOT_ERROR);
	size = align(sizeof(struct slot_hdr));
	size += align(sizeof(struct slot_error_hdr));
	size += strlen(string) + 1;
	s.subslot.error.se_type = type;
	strcpy(s.subslot.error.msg,string);
	finish_slot(m,&s,size);
}
