/* 

these functions are used by the CMM to read and process information from
incoming slots

*/

#include <sys/time.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "cm_constants.h"
#include "cm_var.h"
#include "cm_sd.h"
#include "cm_slot.h"
#include "cm_man.h"
#include "cm_msg.h"
#include "cm_time.h"

struct variable *get_variable();

extern struct process processes[];
extern struct msg *cm_omsg;	/* defined in man.c */

#define TRUE 1
#define FALSE 0

int /* returns 0 if ok, negative if error */
man_decode_slot(s,pin)
struct slot *s;
int pin;		/* process index */
{
	int rc = 0;

	switch (s->s_type) {
	case CM_SLOT_DECLARE:
		eprintf(5,"slot declare\n");
		rc = get_slot_declare(s->s_name,&s->subslot.declare,pin);
		break;
	case CM_SLOT_WRITE:
		eprintf(5,"slot write\n");
		rc = get_slot_write(s->s_name,&s->subslot.write,pin);
		break;
#if 0
	case CM_SLOT_READ:
		eprintf(5,"slot read\n");
		/* note this destroys the message first, so this should */
		/* always appear as the last slot */
		send_read_vars_to(cm_omsg,pin);
		break;
#endif
	case CM_SLOT_UNDECLARE:
		eprintf(5,"slot undeclare\n");
		rc = get_slot_undeclare(s->s_name,&s->subslot.undeclare,pin);
		break;
	default:
		printf("slot bad");
		put_slot_error(cm_omsg,s->s_name,CM_SLOT_NULL,
			"bad slot type");
		rc = E_CM_GET_SLOT_UNKNOWN_SLOT_TYPE;
		break;
	}
	eprintf(5,"successfully decoded slot (%s %s)\n",
			s->s_name,cm_slot_type(s->s_type));
	return(rc);
}

int /* returns 0 if ok */
get_slot_declare(name,s,pin)
char *name;
struct slot_declare *s;
int pin;
{
	struct variable *v;

	if (!(v = get_variable(name))) {
	    put_slot_error(cm_omsg,name,CM_SLOT_DECLARE,
		"not enough common memory to declare variable");
	    return(E_GET_VARIABLE_NO_SPACE);
	}

	/* check access rights */
	if (s->role.reader) {
		set_reader(pin,v);
		/* if it's been written, note that */
		if (v->count) set_new(pin,v);
	}
	if (s->role.wakeup) {
		set_wakeup(pin,v);
		/* if it has a new value, wake us up */
		if (is_new(pin,v)) processes[pin].wakeup = TRUE;
	}
	if (s->role.nonxwriter) {
		if (v->xwriter == CM_NULL_PROCESS)
			set_nonxwriter(pin,v);
		else {
			put_slot_error(cm_omsg,name,CM_SLOT_DECLARE,
				"cannot get nonexclusive write access");
			return(E_CM_DECLARE_CANT_GET_XWRITE_ACCESS);
		}
	}
	if (s->role.xwriter) {
		if (v->xwriter == CM_NULL_PROCESS
		    || is_xwriter(pin,v)) {
			set_xwriter(pin,v);
		} else {
			put_slot_error(cm_omsg,name,CM_SLOT_DECLARE,
				"cannot get exclusive write access");
			return(E_CM_DECLARE_CANT_GET_XWRITE_ACCESS);
		}
	}

#if 0
	/* update cm_variable_list */
	for (i=0;
#endif

	return(0);
}

/*ARGSUSED*/
int
get_slot_undeclare(name,s,pin)
char *name;
struct slot_undeclare *s;
int pin;
{
	struct variable *v;

	if (!(v = get_variable(name))) {
		put_slot_error(cm_omsg,name,CM_SLOT_UNDECLARE,
			"undeclare of undeclared variable");
		return(E_CM_UNDECLARE_UNDECLARE);
	}
	if (!var_inuse(v)) {
		put_slot_error(cm_omsg,name,CM_SLOT_UNDECLARE,
			"undeclare of undeclared variable");
		return(E_CM_UNDECLARE_UNDECLARE);
	}	
	unset_reader(pin,v);
	unset_writer(pin,v);
	unset_wakeup(pin,v);

	/* note: var_inuse may have different value now */
	if (!var_inuse(v)) {
		/* if var had been set, free up any space taken by it */
		if (v->count) {
			cm_sd_free(&v->data);
			v->count = 0;
		}

		/* remove from cm_variable_list */
	}
	return(E_CM_SLOT_OK);
}

int /* returns 0 if ok, error otherwise */
get_slot_write(name,s,pin)
char *name;
struct slot_write *s;
int pin;
{
	int i;
	struct variable *v;

	if (!(v = get_variable(name))) {
	    put_slot_error(cm_omsg,name,CM_SLOT_WRITE,
		"not enough common memory to declare variable");
	    return(E_CM_DECLARE_GET_VARIABLE_NO_SPACE);
	}

	/* if variable has not been declared, error */
	if (!var_inuse(v)) {
	    put_slot_error(cm_omsg,name,CM_SLOT_WRITE,
		"variable has not been declared");
	    return(E_CM_WRITE_NOT_DECLARED_YET);
	}

	/* check access */
	if (!(is_writer(pin,v))) {
	    put_slot_error(cm_omsg,name,CM_SLOT_WRITE,
		"not declared as writer");
	    return(E_CM_WRITE_NOT_WRITER);
	}

	/* write new value */
	if (0 > cm_flat_to_sd(&s->fdata,&v->data)) {
	    put_slot_error(cm_omsg,name,CM_SLOT_WRITE,
		"get_slot_write: cm_flat_to_sd() failed!  no space?\n");
	    return(E_CM_GET_SLOT_FLAT_TO_SD);
	}
	/* the CMM generates new values for count and timestamp */
	v->count++;
	time_now(&v->timestamp);
	/* the user generates new values for command_association */
	v->command_association = s->sw_hdr.command_association;

	for (i=0;i<CM_MAXPROCESSES;i++) {
		set_new(i,v);
		/* flag any processes to be woken up */
		if (is_wakeup(i,v)) {
			processes[i].wakeup = TRUE;
		}
	}
	return(E_CM_SLOT_OK);
}

#if 0
/*ARGSUSED*/
int /* returns 0 if ok, error otherwise */
get_slot_read(name,s,pin)
char *name;
char *s; /*struct slot_read *s;*/
int pin;
{
	struct variable *v;

	v = get_variable(name);

	if (!var_inuse(v)) {
		put_slot_error(cm_omsg,name,CM_SLOT_READ,
			"variable not defined");
		return(E_CM_READ_NOT_DECLARED_YET);
	}

	/* check access */
	if (!(is_reader(pin,v))) {
	    put_slot_error(cm_omsg,name,CM_SLOT_READ,
		"not declared as reader");
	    return(E_CM_READ_NOT_READER);
	}

	/* read value, create slot, and add to outgoing message buffer */
	put_slot_read_response(cm_omsg,name,v->count,
		&v->timestamp,v->command_association,&v->data);
	return(E_CM_SLOT_OK);
}
#endif
