/* server1y.c

This process prints the latest values of variables a_var and b_var when
the user presses return.

*/
#include <sys/time.h>
#include "cm.h"

cm_value a_val = {0,0,0,1}, b_val = {0,0,0,1};

main()
{
	cm_variable *a_var, *b_var;

	if (0>cm_init("press return",0,0)) exit(-1);

	if (!(a_var = cm_declare("a_var",CM_ROLE_READER)))
			exit(-1);
	if (!(b_var = cm_declare("b_var",CM_ROLE_READER)))
			exit(-1);

	printf("press return for latest values\n");
	for (;;) {
		getchar();
		cm_sync(CM_WAIT_READ);
		cm_get_value(a_var,&a_val);
		printf("a_var: %s\n",a_val.data);
		cm_get_value(b_var,&b_val);
		printf("b_var: %s\n",b_val.data);
	}
}
