/*

These are some utility routines for building slots.  These slots
are placed in a msg structure and sent from the user to the cmm or vice-versa.

*/

#include <stdio.h>
#include <sys/time.h>
#include <strings.h>
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_slot.h"	/* definitions of slot structures */
#include "cm_msg.h"	/* definitions of msg structures */
#include "cm_bytestuff.h"

#define TRUE 1
#define FALSE 0

extern char cm_process_name[];

int	/* returns # of bytes written into msg structure */
finish_slot(m,slot,slotsize)
struct msg *m;
struct slot *slot;
unsigned int slotsize;
{
	if (m->size + slotsize > CM_MSGSIZE) {
		fprintf(stderr,"too much data for msg!!\n");
		fprintf(stderr,"output msg size = %d  slotsize = %d  CM_MSGSIZE = %d\n",
			m->size,slotsize,CM_MSGSIZE);
		return(0);
	}
	/* copy slot into msg after previous slot */
	slot->s_size = slotsize; /* this is not aligned, right? */
	eprintf(10,"finish_slot: bcopying slot (size = %d) into msg\n",
						slot->s_size);
	safebcopy((char *)slot,(char *)byteadd(m,m->size),slotsize);
	eprintf(10,"finish_slot: after bcopy, message slot size = %d\n",
				((struct slot *)byteadd(m,m->size))->s_size);
	m->slots++;
	m->size += align(slotsize);
	return(align(slotsize));
}

init_msg(m)
struct msg *m;
{
	m->version = CMM_VERSION;
	m->slots = 0;
	m->read_wait = FALSE;
	strcpy(m->name,cm_process_name);
	m->size = sizeof(struct msg) - sizeof(struct slot);
}

/*
init_slot does the following:
	sets the slot name and type
*/
init_slot(s,name,type)
struct slot *s;
char *name;
int type;
{
	s->s_type = type;
	strcpy(s->s_name,name);
}

char *
cm_slot_type(t)
int t;
{
	switch (t) {
	case CM_SLOT_NULL: return("null slot type");
	case CM_SLOT_DECLARE: return("declare");
	case CM_SLOT_WRITE: return("write");
	case CM_SLOT_READ: return("read");
	case CM_SLOT_READ_RESPONSE: return("read response");
	case CM_SLOT_ERROR: return("error");
	case CM_SLOT_UNDECLARE: return("undeclare");
	default: return("unknown slot type");
	}
}
