/*

This file contains definitions relating to message passing between
the CM manager and user.

Slots types are
*/

#define CM_SLOT_NULL		0
#define CM_SLOT_DECLARE		1
#define CM_SLOT_WRITE		2
#define CM_SLOT_READ		3
#define CM_SLOT_READ_RESPONSE	4
#define CM_SLOT_ERROR		6
#define CM_SLOT_UNDECLARE		7

/* slot handling errors */
#define E_CM_SLOT_OK				0
#define E_CM_GET_SLOT_UNKNOWN_SLOT_TYPE		-1
#define E_CM_GET_SLOT_GET_VARIABLE		-2
#define E_CM_GET_SLOT_FLAT_TO_SD		-3
#define E_CM_GET_SLOT_BAD_INUSE			-4	/* we have received a
		/* declaration, declared it, and yet it ended up with
		/* no readers or writers? */

/* semantic user errors */
#define E_CM_DECLARE_CANT_GET_XWRITE_ACCESS	-4
#define E_CM_DECLARE_GET_VARIABLE_NO_SPACE		-6

#define E_CM_WRITE_NOT_DECLARED_YET		-7
#define E_CM_WRITE_NOT_WRITER			-8

#define E_CM_READ_NOT_DECLARED_YET			-9
#define E_CM_READ_NOT_READER			-10

#define E_CM_UNDECLARE_UNDECLARE			-11

/*
This slot is sent by the manager back to the user in response to a
SLOT_READ.
*/

struct slot_read_response_hdr {
	unsigned long count;
	struct timeval timestamp;
	int command_association;
};

#define srr_count		srr_hdr.count
#define srr_timestamp		srr_hdr.timestamp
#define srr_command_association	srr_hdr.command_association

struct slot_read_response {
	struct slot_read_response_hdr srr_hdr;
	/* the following two entries are the flattened out sdata structure */
	/* and should probably be declared that way */
	struct cm_flattened_data fdata;	/* flattened data */
};

/*
This slot is sent by the user to the manager when writing a value
*/

struct slot_write_hdr {
	int command_association;
/*	union flattened_data fdata;*/
};

#define sw_command_association	sw_hdr.command_association

struct slot_write {
	struct slot_write_hdr sw_hdr;
	struct cm_flattened_data fdata;
};

#if 0
/* this slot is sent to the manager when requesting a variable value.
Currently, it is empty, but since the C compiler doesn't like empty
structures we put in a single character (that will never be looked at)
*/
struct slot_read {
	char dummy;	/* this is not used except to take up space */
};
#endif

struct slot_role {
	unsigned reader : 1;
	unsigned wakeup : 1;
	unsigned xwriter : 1;
	unsigned nonxwriter : 1;
};

/* this slot is sent by the user to the manager when declaring variables */
struct slot_declare {
	int command_association;
	struct slot_role role;
};

/* this slot is sent by the user to the manager when undeclaring variables */
struct slot_undeclare {
	char dummy;	/* this is not used except to take up space */
};

/* this slot is sent to the user for a number of reasons (all bad!) */
struct slot_error_hdr {
	/* unsigned size; */
	int type;	/* type of error */
};

#define se_type			se_hdr.type

struct slot_error {
	struct slot_error_hdr se_hdr;
	char msg[1];
};

/*
Each slot structure is different depending on what slot type it is.
All slots however, contain a slot type and slot name.
*/
union slot_generic {
	struct slot_declare declare;
#if 0
	struct slot_read read;
#endif
	struct slot_write write;
	struct slot_read_response read_response;
	struct slot_error error;
	struct slot_undeclare undeclare;
/* a command slot is for variables that should be directly interpreted
/* by the CMM itself.  However, this is not currently used.  */
/*	struct slot_command command; what the hell is this? */
};

struct slot_hdr {
	char name[CM_VARIABLENAMELENGTH];
	int type;		/* type of the slot structure */
	int size;		/* size of the slot structure */
};

#define s_name slot_hdr.name
#define s_type slot_hdr.type
#define s_size slot_hdr.size

struct slot {
	struct slot_hdr slot_hdr;
	union slot_generic subslot;
};

/* same as slot but has buffer space at end */
/* the others are used for handing to sizeof */
struct big_slot {
	char name[CM_VARIABLENAMELENGTH];
	int type;
	int size;
	union slot_generic subslot;
	char buffer[CM_SLOTSIZE];
};
