/*					-[Wed Jun  5 21:16:25 1985 by layer]-
** 	lstructs.h			$Locker:  $
**   lisp data object structure definitions
**
** $Header: lstructs.h,v 40.17 85/06/06 16:03:19 layer Exp $ *
** 
** (c) copyright 1984, Franz Inc., Berkeley California
*/

typedef union lispobj *lispval;

struct dtpr {
    lispval	cdr, car;
};

struct sdot {
    word 	I;
    lispval	CDR;
};


/*
** If you change the size of the following structure, then
** you must also do the following:
**	1. give ATOMSPP a new value (in structs.h), which is:
**		integer part of (512 / sizeof (struct atom))
**	2. fix the initialization of nilatom and eofatom in low.c
**	3. fix the init of atom_str in data.c
**
** NOTE: there are places in the imterpreter and compiler which
**	know about offsets in the atom structure, and they are:
**	 1. {vax,68k}/qfuncl (the #define Atomfnbnd)
**	 2. const.l in the compiler (bindv-offset and clb-offset).
*/
struct	atom	{
    lispval		clb;		/* current level binding */
    lispval	        bindv;		/* pointer to the current value */
    char		*pname;		/* print name */
    lispval		fnbnd;		/* function binding */
    lispval		pkg;		/* home package (for printing) */
    lispval		plist;		/* property list */
};

/* all references to the value of a symbol should use the following macro */
#define SymValue(x) (((x)->a.bindv)->a.clb)

struct array {
    lispval accfun,		/*  access function--may be anything  */
	    aux;		/*  slot for dimensions or auxilliary data  */
    char *data;			/*  pointer to first byte of array    */
    lispval length, delta;	/* length in items and length of one item */
};

struct bfun {
    lispval (*start)();	/*  entry point to routine  */
    lispval	discipline;	/*  argument-passing discipline  */
#ifdef apollo
    lispval	canlink;	/* can link this function in trantb */
    lispval	(*ecb)();	/*  pointer to ecb */
    lispval	(*ecb2)();	/*  second pointer to ecb */
#endif apollo
};

struct Hunk {
	lispval hunk[1];
};

struct Vector {
        lispval vector[1];
};

/* the vectori types */
struct Vectorb {
    	char vectorb[1];
};

/* The manual says this must be 16 bits */
struct Vectorw {
       short  vectorw[1];
};

struct Vectorl {
	int32 vectorl[1];
};

struct Vectorf {
	float vectorf[1];
};

struct Vectord {
	double vectord[1];
};

struct Hasht {
	lispval size;
	lispval test;
	lispval count;
	lispval rehash_size;
	lispval rehash_thres;
	lispval bucket;
};

/*
** if you change the size of this structure, then
** change the initialization of boguslp in data.c
*/
struct package {
	lispval tables;
	lispval name;
	lispval nicknames;
	lispval use_list;
	lispval used_by_list;
	lispval internal_symbols;
	lispval external_symbols;
	lispval shadowing_symbols;
};

union lispobj {
	struct atom a;
	struct array ar;
	struct bfun bcd;
	char c;
	char *st;	/* string */
	struct dtpr d;
	lispval (*f)();
	struct Hunk h;
	struct Hasht ht;
	word i;
	word *j;
	lispval l;
	FILE *p;
	struct package pk;
	double r;
	struct sdot s;
	struct Vector v;
	struct Vectorb vb;
	struct Vectorw vw;
	struct Vectorl vl;
	struct Vectorf vf;
	struct Vectord vd;
};

/* offset of size info from beginning of vector, 
	in longwords (ie 32 bit words) */
/* these values are not valid when a vector is stored in the free */
/* list, in which case the chaining is done through the propery field */
#define VSizeOff -2
#define VPropOff -1

/* VecTotSize: the total number of longwords for the data segment of
 * the vector. Takes a byte count and rounds up to nearest long.
 */

#define VecTotSize(x)  (((x)+3) >> 2)
#define VecTotToByte(x) ((x) * sizeof(word))

/* these vector size macros determine the number of complete objects
   in the vector
 */
#define VecSize(x) 	((x) >> 2)
#define VecWordSize(x)	((x) >> 1)
#define VecByteSize(x)	(x)
#define VecFloatSize(x)	((x) >> 2)	/* not used yet */
#define VecDoubSize(x)	((x) >> 3)	/* not used yet */

#define VSIZE(vec)	VecSize((int)vec->v.vector[VSizeOff])
/*
 * internal lisp structures
 */

/*
 * nament is misnamed. It is actually the structure of a bindstack entry
 * recording the saved value (val) of a symbol (atm) and bindv
 */
struct nament {
    lispval	val,
		atm,
		bindv;
};

/*
 * argent is the structure of an object on the namestack, which
 * is a stack of lisp values, usually arguments to functions and
 * local variables in compiled code.
 */
struct argent {
	lispval	val;
};
