/*
 * $Header: rsend.h,v 1.7 85/09/12 15:07:15 zap Exp $
 */

/*
 * Revision 1.2  85/08/17  01:44:22  zap
 * New format for msg - request type field added, request types can be
 * CHECK (check if reciver is logged in and tty writeable) and SEND
 * (go ahead and send message).
 * 
 * Revision 1.1  85/08/16  21:42:05  zap
 * Initial revision
 * 
 *    rsend.h    1.0    zap@bogart	1985-07-02 03:39:48
 */

/*
** Copyright (C) 1985 by Svante Lindahl.
**
** rsend - send a message to a local or remote user
**
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <pwd.h>
#include <utmp.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <sys/time.h>
#include "/usr/src/net/rwhod/rwhod.h"

#define TRUE	1
#define	FALSE	0
#define ever	;;

#ifdef	TEST
#define RENDEZ_VOUS	11147
#endif

#define NAME_SIZE	9
#define TTY_SIZE	8
#define	LINE_LENGTH	80
#define BUF_SIZE	400
#define HOST_NAME_SIZE	32

#define WHDRSIZE   (sizeof(wd) - sizeof (wd.wd_we))

/* request values */
#define	CHECK		0
#define	SEND		1

/* response values */
#define SUCCESS		0
#define NO_USER		1
#define NOT_IN		2
#define NOT_TTY		3
#define	WRNG_TTY	4
#define NOT_USED	5
#define	DENIED		6
#define OP_UTMP		7
#define OP_TTY		8
#define WR_FAIL		9
#define CONFUSED	10
#define NO_ANSW		11
#define CHDIR		12

/* Seems like nr of bytes must be divisible by 4 to work between Sun and VAX */
struct rsend_msg {	
	char rcv_name[NAME_SIZE];   /*   9 */
	char rcv_tty[TTY_SIZE];     /*   8 */
	char rqst_type;		    /*   1 */
	char fill[2];		    /*   2 */
	char text[BUF_SIZE];        /* 400 */
} msg;

/* Seems like nr of bytes must be divisible by 4 to work between Sun and VAX */
struct rsend_rsp {
        char code;                  /*   1 */
	char fill[2];               /*   2 */
        char rcv_name[NAME_SIZE];   /*   9 */
        char rcv_tty[TTY_SIZE];     /*   8 */
} rsp;

extern int errno;
