#ifndef lint
static char *RCSid = "$Header: rsendd.c,v 1.8 85/12/30 22:56:16 zap Exp $";
static char *Copyright = "rsendd.c  Copyright (C) 1985 Svante Lindahl.";
#endif

/*
 * $Log:	rsendd.c,v $
 * Revision 1.8  85/12/30  22:56:16  zap
 * Made lint happier.
 * 
 * Revision 1.7  85/10/06  19:50:46  zap
 * Problem: daemon would occasionally get hung, fix(?): timeout after 3
 * seconds in wait and send a SIGKILL to the child.
 * 
 * Revision 1.6  85/10/06  19:04:30  zap
 * Bugfix; didn't recognize that a tty was unused, badly placed '!' removed.
 * 
 * Revision 1.5  85/08/21  18:27:59  zap
 * Better way of finding tty with least idletime.
 * 
 * Revision 1.4  85/08/19  23:09:44  zap
 * The daemon now tries to find reciver's job with least idletime if no
 * particular tty is requested.
 * 
 * Revision 1.3  85/08/19  21:10:34  zap
 * Some small fixes.
 * 
 * Revision 1.2  85/08/17  01:31:28  zap
 * Checks if person is logged in and tty is writeable when called with
 * request type CHECK, only writes on tty with request is set to SEND.
 * 
 * Revision 1.1  85/08/16  21:40:20  zap
 * Initial revision
 * 
 * rsendd.c    1.0    zap@bogart	1985-07-05 18:00:30
 *
 */

/*
** rsendd - daemon for rsend a message sending program 
**
** This program, and any documentation for it, is copyrighted by Svante
** Lindahl. It may be copied for non-commercial use only, provided that
** any and all copyright notices are preserved.
**
** Please report any bugs and/or fixes to:
**
** UUCP: {seismo,mcvax,cernvax,diku,ircam,prlb2,tut,ukc,unido}!enea!ttds!zap
** ARPA: enea!ttds!zap@seismo.ARPA
**   or  Svante_Lindahl_NADA%QZCOM.MAILNET@MIT-MULTICS.ARPA
**
*/

#include "rsend.h"

#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/resource.h>

#ifdef	INET_D
#define TIMEOUT	30        /* let the daemon time out and exit if.. */
#define MAXIDLE	120       /* ..it is invoked by the inet-daemon    */
#endif

struct	sockaddr_in sin, from ;
int	fromlen = sizeof(from) ;
extern	int doit() ;

#ifndef DEBUG
int	pid ;
long	lastmsgtime ;
#endif

main ()
{
    int s, f, cc, w;
    union wait status;
    int (*saveintr)(), (*savequit)();
    struct passwd *getpwnam() ;
    struct servent *sp ;
#ifndef	DEBUG
    extern	void reaper(), chaser() ;
#endif
#ifdef	INET_D
    extern	void timeout() ;
#endif
    
    sin.sin_addr.s_addr = INADDR_ANY ;
    sin.sin_family = AF_INET ;
#ifndef TEST
    if (getuid()) {
        fprintf (stderr, "rsendd: not super user\n") ;
        exit(1) ;
    }
    sp = getservbyname("rsend", "udp") ;
    if (sp == NULL) {
        fprintf (stderr, "rsendd: udp/rsend: unknown service\n") ;
        exit(1) ;
    }
    sin.sin_port = sp->s_port ;
#else
    sin.sin_port = htons(RENDEZ_VOUS) ;
#endif
#ifndef	DEBUG
     /* fork, parent quits, child dissociates itself from the tty */
    if (fork())
        _exit(0) ;
    for (f = 0 ; f < 5 ; f++)
        (void) close(f) ;
    (void) open("/dev/null", O_RDONLY) ;
    (void) open("/dev/null", O_WRONLY) ;
    (void) dup(1) ;
    if ((f = open("/dev/tty", O_RDWR)) > 0) {
        (void) ioctl(f, (int) TIOCNOTTY, (char *) 0) ;
        (void) close(f) ;
    }
    s = socket(AF_INET, SOCK_DGRAM, 0) ;
    if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
        perror("rsendd: bind") ;
        exit(1) ;
    }
    (void) signal(SIGCHLD, reaper) ;    /* try not to leave zombies around */
    for(ever) {
        cc = recvfrom(s, (char *)&msg, sizeof(msg),
                      0, (struct sockaddr *) &from, &fromlen);
        if ((pid = vfork()) == 0)
            exit(doit(s, cc)) ;
        (void) time(&lastmsgtime) ;
        saveintr = signal(SIGINT, SIG_IGN) ;
        savequit = signal(SIGQUIT, SIG_IGN) ;
	(void) signal(SIGALRM, chaser) ;
        (void) alarm(3);
        while ((w = wait(&status)) != pid && w != -1)
            ;
        (void) signal(SIGQUIT, saveintr) ;
        (void) signal(SIGQUIT, savequit) ;
#ifdef	INET_D
        (void) signal(SIGALRM, timeout) ;
        (void) alarm(TIMEOUT) ;
#else
	(void) alarm(0) ;
#endif
    }
#else
    s = socket(AF_INET, SOCK_DGRAM, 0) ;
    if (bind(s, &sin, sizeof(sin)) < 0) {
        perror("rsendd: bind") ;
        exit(1) ;
    }
    for(ever) {
        cc = recvfrom(s, (char *)&msg, sizeof(msg), 0, &from, &fromlen) ;
        doit(s, cc) ;
    }
#endif
}

int
doit(s, cc)
    int s, cc ;
{
    int  f, i, idle = -1 ;
    struct stat st ;
    struct utmp ut ;
    struct passwd *pwp ;
    long   now ;

    if (cc != sizeof(msg)) {
        if (cc < 0 && errno != EINTR)
            perror("recvfrom") ;
        return(1) ;
    }
    if (chdir("/dev") < 0)
        rsp.code = CHDIR ;
    else if (*msg.rcv_tty != '\0') {
        (void) strcpy(rsp.rcv_tty, msg.rcv_tty) ;
        if (stat(msg.rcv_tty, &st) < 0)
            rsp.code = NOT_TTY ;
        else if (((st.st_uid == 0) && (strcmp(msg.rcv_name, "root")))
          || (pwp = getpwuid(st.st_uid)) == NULL)
            rsp.code = NOT_USED ;
        else if (*msg.rcv_name != '\0') {
            (void) strcpy(rsp.rcv_name, msg.rcv_name) ;
            if (getpwnam(msg.rcv_name) == NULL)
                rsp.code = NO_USER ;
            else if (strcmp(msg.rcv_name, pwp->pw_name) != 0)
                rsp.code = WRNG_TTY ;
            else if (!(st.st_mode & 2))
                rsp.code = DENIED ;
            else
                rsp.code = SUCCESS ;
        } else {
            if (!(st.st_mode & 2))
                rsp.code = DENIED ;
            else {
                rsp.code = SUCCESS ;
                (void) strcpy(rsp.rcv_name, pwp->pw_name) ;
            }
        }
    } else if (*msg.rcv_name != '\0') {
        (void) strcpy(rsp.rcv_name, msg.rcv_name) ;
        if (getpwnam(msg.rcv_name) == NULL)
            rsp.code = NO_USER ;
	else if ((f = open ("/etc/utmp", 0)) < 0)
	    rsp.code = OP_UTMP ;
	else {        /* search for reciver in /etc/utmp */
	    rsp.code = NOT_IN ;
	    (void) time(&now) ;
	    while (read (f, (char *)&ut, sizeof(ut)) > 0) {
		if (strcmp(msg.rcv_name, ut.ut_name) == 0) {
		    if ((stat(ut.ut_line, &st) >= 0) && (st.st_mode & 2) 
                      && (((i = now - st.st_mtime) < idle) || (idle = -1))) {
                        (void) strcpy(rsp.rcv_tty, ut.ut_line) ;
			rsp.code = SUCCESS ;
                        idle = i ;
		    } else if (rsp.code != SUCCESS) {
                        (void) strcpy(rsp.rcv_tty, ut.ut_line) ;
			rsp.code = DENIED ;
		    }
		}
	    }
	    (void) close(f) ;
        }
    } else
        rsp.code = CONFUSED ;        /* hopefully not reached... */

    if (rsp.code == SUCCESS) {       /* found somewhere to send it */
        if ((f = open(rsp.rcv_tty, O_WRONLY)) < 0)
            rsp.code = OP_TTY ;
        else if (msg.rqst_type == SEND) {
            if (write(f, msg.text, strlen(msg.text)) != strlen(msg.text))
                rsp.code = WR_FAIL ;
            (void) close(f) ;
        }
    }
    /* send status report to the sender */
    cc = sendto(s, (char *)&rsp, sizeof(rsp),
                0, (struct sockaddr *) &from, sizeof(from)) ;
    return(cc == sizeof(rsp) ? 0 : -1) ;
}

#ifdef	INET_D
void
timeout()
{
    long now ;

    (void) time(&now) ;
    if (now - lastmsgtime >= MAXIDLE)
        exit(0) ;
    (void) alarm(TIMEOUT) ;
}
#endif

#ifndef DEBUG
void
reaper()            /* takes care of getting rid of zombie-children */
{
    union wait status ;

    while (wait3(&status, WNOHANG, (struct rusage *) 0) > 0) ;
}

void
chaser()	    /* chase down children that refuse to die */
{
    (void) kill(pid, SIGKILL) ;
}
#endif
