:
# Deliver script for RNALIB 2.0  	- by  venta@i2ack.sublink.org
#
# This script is for the 'deliver' mail package by Chip Salzenberg.
# Put it inside rnalib home directory as .deliver, and you will get
# sequential processing of RNA mail, instead of parallel ones.
# Carefully check everything is ok, or your system will get a bunch
# of dangerous sessions spreading around as hells.
# Note#1: Chip has sent out new patches for his 'deliver'. Maybe if
#         you have this new release something will not work, or 
#         (probably) will work much better ;-)
#
# Note#2: THIS SCRIPT IS NOT SUPPORTED. It was written months ago
#         while trying to find a solution in order to run RNA on a
#         286 system. The 286 shell shouts and dies running RNA.
#         When RNA was not as big, still there was a chance to make it
#         work without core dumps (!). This is just an example of
#         how 'deliver' can be used with rna. It's an old example,
#         found in an old directory of an old release of RNA.
#         So take it as a simple idea of how to do it.
#         If you run 'deliver' you could use it for having RNA processing
#         incoming mails 'realtime'. This script is supposed to process
#         them once at a time. 
#
user=$1
# MAILBOX=/usr/local/usr/rnalib/box

# create your own lock
touch $HOME/lock.$$

# how many delivers pending?
set `ls -l $HOME/lock.* 2>/dev/null | wc -l`

# determine a syncronization wait time; if your system is *fast, then
# higher the multiply factor
sync_time=`expr $1 \* 3`

# first attempt to queue
sleep $sync_time

# does a queue exist?
while test -r $HOME/lock
do
#	wait until your turn
	sleep $sync_time
done

#	My turn now!
touch $HOME/lock
date >>account
# If the next line is  creating stdin errors...
cat $HEADER $BODY | deliver -n "$user" 
# .. jump over the pipe and do it your way!
# cat $HEADER $BODY >>$MAILBOX

# If you use 'deliver -n' then higher sleep time in order to let deliver
# complete its mailing, or RNA won't find anything to process!
sleep 5

# force an RNA session
/bin/sh /usr/local/usr/rnalib/RNA 

# remove queue lock: a new RNA session will start
rm $HOME/lock 2>/dev/null

# Sleep again to assure that new delivers don't get an already used sync_time.
# This way it will be harder to happen.
sleep $sync_time
rm $HOME/lock.$$

# quit living and forget about any further delivery please!
# ("Trust me, i know what i am doing..")
echo "DROP"
