/* queue.h - Dan Lanciani '85 '89 */

#define LIBDIR "/usr/lib/queued"
#define QUEUES "/usr/lib/queued/QUEUES"

#define SPOOLDIR "/usr/spool/queued"
#define LOCKNODE "/usr/spool/queued/LOCK"
#define UNID "/usr/spool/queued/UNID"

#define QACCT "/usr/adm/qacct"

#define FLATFILE "/etc/hosts.flat"
#define EFSFILE "/etc/hosts.efs"
#define EQUIVFILE "/etc/hosts.equiv"

#define QUEUEGROUP "queued"

#define NOBODY -2
#define XGROUPS 32
#define MAXUQ 4
#define MAXHCNT 50

struct optent {
	struct optent *op_next;
	char *op_name;
	int op_action;
	char *op_arg;
};

#define OPA_IGNORE 0
#define OPA_COPYIN 1
#define OPA_COPYOUT 2

#define QM_BATCH 0
#define QM_BACKGROUND 1
#define QM_INTERACTIVE 2

extern char prog[BUFSIZ], host[BUFSIZ], qm[BUFSIZ], queue[BUFSIZ], *hosts[];
extern int maxcpu, minnice, maxrun, maxload, minload, mode, priv, efs, restart;
extern int hcnt, maxtime, nolocal, maxperu;
extern struct optent *copyin;
extern struct optent *copyout;
extern struct optent *option;

#define malloc xmalloc
#define FIRSTUNID (256L * 65536L)
#define LASTUNID (32767L * 65536L)
#define isunid(p) ((p) >= FIRSTUNID && (p) <= LASTUNID)

char *getenv();
char *malloc(), *index(), *rindex();
char *newstring();
char *getstr(), *fgetstr();
long atol();
