/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* getload.c - Dan Lanciani '85 */

#include <nlist.h>

struct	nlist nl[] = {
	{ "_avenrun" },
#define	X_AVENRUN	0
	{ "" },
};

int	kmem = -1;
double	avenrun[3];

getload()
{
	if(kmem < 0 && (kmem = open("/dev/kmem", 0)) < 0)
		return(0);
	if(!nl[0].n_type) {
		nlist("/vmunix", nl);
		if(!nl[0].n_type)
			return(0);
	}
	lseek(kmem, (long)nl[X_AVENRUN].n_value, 0);
	if(read(kmem, avenrun, sizeof(avenrun)) != sizeof(avenrun))
		return(0);
	return((int)(100.0 * avenrun[0]));
}
