/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* readconf.c - Dan Lanciani '85 */

#include <stdio.h>
#include "queue.h"

char prog[BUFSIZ], host[BUFSIZ], qm[BUFSIZ], queue[BUFSIZ];
char *hosts[MAXHCNT];
int maxcpu, minnice, maxrun, minload, maxload, mode, priv, efs, restart;
int hcnt, maxtime, nolocal, maxperu;
struct optent *copyin = NULL;
struct optent *copyout = NULL;
struct optent *option = NULL;

readconf(p)
char *p;
{
	register FILE *n, *m;
	char name[BUFSIZ], buf[BUFSIZ], action[BUFSIZ], arg[BUFSIZ];
	register int i;
	register struct optent *op;

	sprintf(name, "%s/%s", LIBDIR, p);
	if(!(n = fopen(name, "r")))
		return(-1);
	if(fscanf(n, "%s %s %s\n", buf, name, prog) != 3) {
		fclose(n);
		return(-2);
	}
	if(strcmp(buf, "program") || strcmp(name, p)) {
		fclose(n);
		return(-3);
	}
	gethostname(host, BUFSIZ);
	qm[0] = '\0';
	strcpy(queue, "test");
	maxcpu = 0;
	minnice = 0;
	maxrun = 1;
	minload = maxload = 0;
	mode = QM_BACKGROUND;
	priv = 0;
	efs = 0;
	restart = 0;
	hcnt = 0;
	maxtime = 0;
	nolocal = 0;
	maxperu = 0;
	if(p = getenv("QMAXCPU"))
		maxcpu = atoi(p);
	if(p = getenv("QMINNICE"))
		minnice = atoi(p);
	if(p = getenv("QMAXTIME"))
		maxtime = atoi(p);
	if(minnice < 0)
		minnice = 0;
	while(fgets(buf, sizeof(buf), n)) {
		buf[strlen(buf)-1] = '\0';
		if(!strncmp(buf, "copyin ", 7)) {
			op = (struct optent *)malloc(sizeof(struct optent));
			op->op_action = OPA_COPYIN;
			op->op_arg = newstring(buf+7);
			op->op_next = copyin;
			copyin = op;
			continue;
		}
		if(!strncmp(buf, "copyout ", 8)) {
			op = (struct optent *)malloc(sizeof(struct optent));
			op->op_action = OPA_COPYOUT;
			op->op_arg = newstring(buf+8);
			op->op_next = copyout;
			copyout = op;
			continue;
		}
		if(!strncmp(buf, "option ", 7)) {
			i = sscanf(buf+7, "%s %s %s", name, action, arg);
			if(!i)
				continue;
			op = (struct optent *)malloc(sizeof(struct optent));
			op->op_name = newstring(name);
			if(i != 3) {
				op->op_action = OPA_IGNORE;
				op->op_arg = "ARG0";
			}
			else {
				if(!strcmp(action, "copyin"))
					op->op_action = OPA_COPYIN;
				else if(!strcmp(action, "copyout"))
					op->op_action = OPA_COPYOUT;
				else op->op_action = OPA_IGNORE;
				op->op_arg = newstring(arg);
			}
			op->op_next = option;
			option = op;
			continue;
		}
		if(!strncmp(buf, "host ", 5)) {
			strcpy(host, buf+5);
			if(host[0] == '/' && (m = fopen(host, "r"))) {
				while(fgets(host, sizeof(host), m)) {
					host[strlen(host)-1] = '\0';
					if(hcnt < MAXHCNT)
						hosts[hcnt++] = newstring(host);
				}
				fclose(m);
			}
			else
				if(hcnt < MAXHCNT)
					hosts[hcnt++] = newstring(host);
			continue;
		}
		if(!strncmp(buf, "qmaster ", 8)) {
			strcpy(qm, buf+8);
			continue;
		}
		if(!strncmp(buf, "maxcpu ", 7)) {
			if((i = atoi(buf+7)) < maxcpu || !maxcpu)
				maxcpu = i;
			continue;
		}
		if(!strncmp(buf, "minnice ", 8)) {
			if((i = atoi(buf+8)) > minnice)
				minnice = i;
			continue;
		}
		if(!strncmp(buf, "maxtime ", 8)) {
			if((i = atoi(buf+8)) < maxtime || !maxtime)
				maxtime = i;
			continue;
		}
		if(!strncmp(buf, "maxrun ", 7)) {
			maxrun = atoi(buf+7);
			continue;
		}
		if(!strncmp(buf, "load ", 5)) {
			sscanf(buf+5, "%d %d", &minload, &maxload);
			continue;
		}
		if(!strncmp(buf, "mode ", 5)) {
			if(!strcmp(buf+5, "batch"))
				mode = QM_BATCH;
			else if(!strcmp(buf+5, "background"))
				mode = QM_BACKGROUND;
			else if(!strcmp(buf+5, "interactive"))
				mode = QM_INTERACTIVE;
			continue;
		}
		if(!strncmp(buf, "queue ", 6)) {
			strcpy(queue, buf+6);
			continue;
		}
		if(!strcmp(buf, "magic")) {
			priv = 1;
			continue;
		}
		if(!strcmp(buf, "efs")) {
			efs = 1;
			continue;
		}
		if(!strcmp(buf, "restart")) {
			restart = 1;
			continue;
		}
		if(!strcmp(buf, "nolocal")) {
			nolocal = 1;
			continue;
		}
		if(!strncmp(buf, "maxperu ", 8)) {
			maxperu = atoi(buf+8);
			continue;
		}
	}
	fclose(n);
	if(!hcnt)
		hosts[hcnt++] = newstring(host);
	hosts[hcnt] = 0;
	return(0);
}
