/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* qs.c - Dan Lanciani '85 */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "queue.h"

extern int errno;
struct servent *sp;

main(argc, argv)
char **argv;
{
	register int i, error = 0;

	if(argc < 1 || argc > 2) {
		fprintf(stderr, "Usage: %s [program]\n", argv[0]);
		exit(1);
	}
	if(!(sp = getservbyname("queue", "tcp"))) {
		fprintf(stderr, "queue: Bad service?!?\n");
		exit(1);
	}
	if(argc == 2) {
		if(readconf(argv[1])) {
			fprintf(stderr, "Unknown configuration\n");
			exit(1);
		}
		if(*qm) {
			if((sp = getservbyname("qmaster", "tcp"))
				&& !show(qm, queue))
				exit(0);
			sp = getservbyname("queue", "tcp");
		}
	}
	else {
		gethostname(host, sizeof(host));
		show(host, "");
		exit(0);
	}
	for(i = 0; i < hcnt; i++)
		error |= show(hosts[i], queue);
	if(error) {
		gethostname(host, sizeof(host));
		show(host, queue);
	}
}

show(h, p)
char *h, *p;
{
	struct sockaddr_in sin;
	register struct hostent *hp;
	int s, trys, i;

	if(!(hp = gethostbyname(h))) {
		fprintf(stderr, "%s: Unknown host?!?\n", h);
		return(1);
	}
	trys = 0;
	i = IPPORT_RESERVED - 1;
retry:
	if((s = rresvport(&i)) < 0) {
		perror("rresvport");
		return(1);
	}
	sin.sin_family = hp->h_addrtype;
	sin.sin_port = sp->s_port;
	bcopy(hp->h_addr, &sin.sin_addr, hp->h_length);
	if(connect(s, &sin, sizeof(sin))) {
		close(s);
		if(trys++ < 5) {
			sleep(trys);
			i--;
			goto retry;
		}
		perror("connect");
		return(1);
	}
	write(s, "\1", 1);
	write(s, p, strlen(p)+1);
	mode = QM_BACKGROUND;
	com(s, -1);
	close(s);
	return(0);
}
