/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* lock.c - Dan Lanciani '85 */

#include <stdio.h>

#include "queue.h"
#include <signal.h>

static int ccnt = 0;

lock(p)
register char *p;
{
	char lock[BUFSIZ];
	register int i;

	close(creat(LOCKNODE, 0644));
	strcpy(lock, p);
	strcat(lock, ".lock");
	for(i = 0; i < 60; i++) {
		if(!link(LOCKNODE, lock)) {
			if(!ccnt++)
				signal(SIGTERM, SIG_IGN);
			return;
		}
		sleep(1);
	}
}

unlock(p)
register char *p;
{
	char lock[BUFSIZ];

	strcpy(lock, p);
	strcat(lock, ".lock");
	unlink(lock);
	if(!--ccnt)
		signal(SIGTERM, SIG_DFL);
}
