/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* getrload.c - Dan Lanciani '89 */

#include <sys/types.h>
#include <sys/stat.h>
#include <protocols/rwhod.h>

getrload(h)
char *h;
{
	register int f;
	char buf[200];
	struct whod awhod;
	struct stat statb;
	time_t t, time();

	sprintf(buf, "/usr/spool/rwho/whod.%s", h);
	if((f = open(buf, 0)) < 0)
		return(10000);
	fstat(f, &statb);
	time(&t);
	if(t - statb.st_mtime > 5*60) {
		close(f);
		return(1000);
	}
	read(f, &awhod, sizeof(awhod));
	close(f);
	return(awhod.wd_loadav[0]);
}
