/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* dequeue.c - Dan Lanciani '85 */

#include <stdio.h>
#include <signal.h>

#include "queue.h"

dequeue(s)
{
	char buf[BUFSIZ], what[BUFSIZ], prog[BUFSIZ], user[BUFSIZ];
	register FILE *n, *m;
	register int i, t, k;
	register long c, u;

	for(i = 0; i < 3; i++)
		dup2(s, i);
	getstr(s, user);
	getstr(s, prog);
	getstr(s, what);
	if(strcmp(what, "all"))
		c = atol(what);
	else
		c = -1;
	if(isunid(c)) {
		sprintf(buf, "%s/%ld", SPOOLDIR, c);
		if(!(n = fopen(buf, "r")))
			exit(0);
		fgetstr(n, buf);
		fclose(n);
		if(!(c = atoi(buf)))
			exit(0);
	}
	if(i = readconf(prog)) {
		fprintf(stderr, "Unknown remote configuration (%d)\n", i);
		exit(1);
	}
	sprintf(buf, "%s/%s", SPOOLDIR, queue);
	if(!(n = fopen(buf, "r"))) {
		fprintf(stderr, "Queue file missing\n");
		exit(1);
	}
	while(fgets(buf, sizeof(buf), n))
		if(c == (k = atoi(buf)) || !c || c == -1) {
			sprintf(buf, "%s/%d", SPOOLDIR, k);
			if(!(m = fopen(buf, "r"))) {
				fprintf(stderr, "Spool file missing (%d)\n", k);
				continue;
			}
			fgetstr(m, buf);
			fgetstr(m, buf);
			u = atol(buf);
			fgetstr(m, buf);
			t = atoi(buf);
			for(i = 0; i < t; i++)
				fgetstr(m, buf);
			fgetstr(m, buf);
			if(!c && strcmp(buf, what)) {
				fclose(m);
				continue;
			}
			if(strcmp(buf, user) && strcmp(user, "root")) {
				if(u)
				fprintf(stderr, "Not owner (%s, %ld)\n", buf,u);
				else
				fprintf(stderr, "Not owner (%s, %d)\n", buf, k);
				fclose(m);
				continue;
			}
			kill(k, SIGTERM);
			if(u)
			fprintf(stderr, "Killed %ld of %s for %s\n",u,buf,user);
			else
			fprintf(stderr, "Killed %d of %s for %s\n", k,buf,user);
			fclose(m);
		}
	fclose(n);
	exit(0);
}
