/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* defer.c - Dan Lanciani '85 */

#include <sys/param.h>
#include <pwd.h>
#include <grp.h>
#include <stdio.h>

char *getenv(), *index(), *rindex(), *malloc();
FILE *popen();
struct passwd *getpwuid();
struct group *getgrgid();

main(argc, argv)
char **argv;
{
	register int i, ng;
	gid_t groups[NGROUPS];
	char buf[BUFSIZ], buf1[BUFSIZ], user[30];
	register char *p;
	FILE *n, *popen();
	register struct passwd *pw;
	register struct group *gr;

	if((i = getgid()) != getegid()) {
		if(!(gr = getgrgid(i))) {
			fprintf(stderr, "What group are you?\n");
			exit(1);
		}
		setenv("GROUP=", gr->gr_name);
	}
	ng = getgroups(NGROUPS, groups);
	setgid(getegid());
	setgroups(ng, groups);
	setuid(i = getuid());
	if(!(pw = getpwuid(i))) {
		fprintf(stderr, "Who are you?\n");
		exit(1);
	}
	strcpy(user, pw->pw_name);
	strcat(user, "\t");
	ng = strlen(user);
	if(p = rindex(argv[0], '/'))
		argv[0] = p + 1;
	for(i = 1; i < argc && argv[i][0] == '-'; i++)
		setenv("QNOTIFY=", &argv[i][1]);
	if(argc == i) {
		printf("Enter command:\n");
		gets(buf);
	}
	else {
		buf[0] = '\0';
		for(; i < argc; i++) {
			strcat(buf, argv[i]);
			if(i < argc - 1)
				strcat(buf, " ");
		}
	}
	if(strcmp(argv[0], "defer.long")) {
		if(n = popen("exec /usr/local/bin/qs bsh", "r")) {
			i = 0;
			while(fgets(p = buf1, sizeof(buf1), n)) {	
				if(!(p = index(p, '\t')))
					continue;
				if(!(p = index(p + 1, '\t')))
					continue;
				if(!strncmp(p + 1, user, ng))
					i++;
			}
			pclose(n);
			if(i > 2) {
				fprintf(stderr, "You have 3 queued already\n");
				exit(1);
			}
		}
		if((p = getenv("SHELL")) && !strcmp(p, "/bin/csh"))
			execl("/usr/queued_pgms/bcsh", "bcsh", "-c", buf, 0);
		else
			execl("/usr/queued_pgms/bsh", "bsh", "-c", buf, 0);
	}
	else {
		if(n = popen("exec /usr/local/bin/qs bsh.long", "r")) {
			i = 0;
			while(fgets(p = buf1, sizeof(buf1), n)) {	
				if(!(p = index(p, '\t')))
					continue;
				if(!(p = index(p + 1, '\t')))
					continue;
				if(!strncmp(p + 1, user, ng))
					i++;
			}
			pclose(n);
			if(i > 2) {
				fprintf(stderr, "You have 3 queued already\n");
				exit(1);
			}
		}
		if((p = getenv("SHELL")) && !strcmp(p, "/bin/csh"))
			execl("/usr/queued_pgms/bcsh","bcsh.long","-c", buf, 0);
		else
			execl("/usr/queued_pgms/bsh", "bsh.long", "-c", buf, 0);
	}
	fprintf(stderr, "Can't find queuer?!?\n");
	exit(1);
}

setenv(var, value)
char *var, *value;
{
	extern char **environ;
	char **envnew;
	int i;
	int varlen = strlen(var);
	int vallen = strlen(value);
	static first = 1;

	if(first) {
		first = 0;
		i = 0;
		while(environ[i])
			i++;
		envnew = (char **) malloc(sizeof (char *) * (i + 1));
		for(; i >= 0; i--)
			envnew[i] = environ[i];
		environ = envnew;
	}
	for(i = 0; environ[i]; i++) {
		if (strncmp(environ[i], var, varlen) == 0) {
			environ[i] = malloc(varlen + vallen + 1);
			strcpy(environ[i], var);
			strcat(environ[i], value);
			return;
		}
	}
	environ = (char **) realloc(environ, sizeof (char *) * (i + 2));
	environ[i] = malloc(varlen + vallen + 1);
	strcpy(environ[i], var);
	strcat(environ[i], value);
	environ[++i] = 0;
}
