/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/

/* com.c - Dan Lanciani '85 */

#include <sgtty.h>
#include <stdio.h>
#include <signal.h>

#include "queue.h"

int tolduser;

com(s, se)
{
	char buf[BUFSIZ];
	register int cnt;

	switch(mode) {

		case QM_BATCH:
			if(!tolduser)
				fprintf(stderr, "Job queued.\n");
			break;

		case QM_BACKGROUND:
			if(se < 0)
				while((cnt = read(s, buf, BUFSIZ)) > 0)
					write(1, buf, cnt);
			else
				modem(s, se, -1, 1, 2);
			break;

		case QM_INTERACTIVE:
			modem(s, se, 0, 1, 2);
			break;

		default:
			fprintf(stderr, "Bad mode (%d)\n", mode);
			break;
	}
}

static long tmask, emask;

modem(s, se, i, o, e)
{
	long isample, osample;
	register int scnt, secnt, tcnt;
	int t, on = 1;
	char sbuf[BUFSIZ], sebuf[BUFSIZ], tbuf[BUFSIZ];
	register char *sp, *sep, *tp;

	ioctl(s, FIONBIO, &on);
	scnt = secnt = tcnt = 0;
	sp = sbuf;
	sep = sebuf;
	tp = tbuf;
	if(i < 0)
		tmask = 0;
	else
		tmask = (1L<<i);
	emask = (1L<<se);
	while(1) {
		isample = osample = 0;
		if(scnt)
			osample |= (1L<<o);
		else
			isample |= (1L<<s);
		if(secnt)
			osample |= (1L<<e);
		else
			isample |= emask;
		if(tcnt)
			osample |= (1L<<s);
		else
			isample |= tmask;
		if(select(32, &isample, &osample, 0, 0) <= 0)
			continue;
		if(isample & (1L<<s))
			if((scnt = read(s, sbuf, BUFSIZ)) <= 0) {
				if(scnt < 0)
					break;
				close(o);
				break;
			}
			else
				sp = sbuf;
		if(isample & (1L<<se))
			if((secnt = read(se, sebuf, BUFSIZ)) <= 0) {
				if(secnt < 0)
					break;
				close(e);
				emask = 0;
			}
			else
				sep = sebuf;
		if(isample & tmask) {
			if(isatty(i)) {
				ioctl(i, TIOCGPGRP, &t);
				if(t != getpgrp(getpid())) {
					shutdown(s, 1);
					tmask = 0;
					continue;
				}
			}
			if((tcnt = read(i, tbuf, BUFSIZ)) <= 0) {
				if(tcnt < 0)
					break;
				shutdown(s, 1);
				tmask = 0;
			}
			else
				tp = tbuf;
		}
		if(osample & (1L<<s)) {
			t = write(s, tp, tcnt);
				if(t < 0)
					break;
			tcnt -= t;
			tp += t;
		}
		if(osample & (1L<<e)) {
			t = write(e, sep, secnt);
				if(t < 0)
					break;
			secnt -= t;
			sep += t;
		}
		if(osample & (1L<<o)) {
			t = write(o, sp, scnt);
				if(t < 0)
					break;
			scnt -= t;
			sp += t;
		}
	}
}
