/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* showqueue.c - Dan Lanciani '85 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "queue.h"

showqueue(s)
{
	struct stat statb;
	char buf[BUFSIZ], tbuf[BUFSIZ], lhost[BUFSIZ];
	register FILE *n, *m, *l;
	register int i, c, oneonly = 0;

	gethostname(lhost, BUFSIZ);
	for(i = 0; i < 3; i++)
		dup2(s, i);
	getstr(s, buf);
	if(s > 2)
		close(s);
	if(*buf) {
		oneonly++;
		goto onlyone;
	}
	if(!(n = fopen(QUEUES, "r"))) {
		fprintf(stderr, "No QUEUES file\n");
		exit(1);
	}

	while(fgets(buf, sizeof(buf), n)) {
		buf[strlen(buf)-1] = '\0';
	onlyone:
		printf("Queue: %s, Host: %s\n", buf, lhost);
		sprintf(tbuf, "%s/%s", SPOOLDIR, buf);
		if(m = fopen(tbuf, "r")) {
			printf("Pid\t\tState\tUser\tHost\tCommand\n");
			while(fgets(buf, sizeof(buf), m)) {
				buf[strlen(buf)-1] = '\0';
				i = atoi(buf);
				sprintf(tbuf, "%s/%s", SPOOLDIR, buf);
				if(l = fopen(tbuf, "r")) {
					fgetstr(l, buf);
					fgetstr(l, buf);
					if(atol(buf))
						printf("%-16ld", atol(buf));
					else
						printf("%-16d", i);
					if(!fstat(fileno(l), &statb) &&
						(statb.st_mode&0111))
						printf("RUN\t");
					else
						printf("WAIT\t");
					fgetstr(l, buf);
					c = atoi(buf);
					for(i = 0; i < c; i++)
						fgetstr(l, buf);
					fgetstr(l, buf);
					printf("%s\t", buf);
					rewind(l);
					fgetstr(l, buf);
					printf("%s\t", buf);
					fgetstr(l, buf);
					fgetstr(l, buf);
					c = atoi(buf);
					for(i = 0; i < c; i++) {
						fgetstr(l, buf);
						printf("%s ", buf);
					}
					fclose(l);
					printf("\n");
				}
			}
			printf("\n");
			fclose(m);
		}
		else
			printf("Warning:  File missing\n\n");
		fflush(stdout);
		if(oneonly)
			exit(0);
	}
	fclose(n);
}
