/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/


/* qrm.c - Dan Lanciani '85 */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pwd.h>

#include "queue.h"

extern int errno;
struct servent *sp;

main(argc, argv)
char **argv;
{
	register struct passwd *pw;
	register int i, error = 0;

	if(argc != 3) {
		fprintf(stderr, "Usage: %s command pid\n", argv[0]);
		exit(1);
	}
	if(!(pw = getpwuid(getuid()))) {
		fprintf(stderr, "Who are you?\n");
		exit(1);
	}
	if(i = readconf(argv[1])) {
		fprintf(stderr, "Unknown configuration (%d)\n", i);
		exit(1);
	}
	if(*qm && (sp = getservbyname("qmaster", "tcp")))
		delq(qm, pw->pw_name, argv[1], argv[2]);
	if(!(sp = getservbyname("queue", "tcp"))) {
		fprintf(stderr, "queue: Bad service?!?\n");
		exit(1);
	}
	for(i = 0; i < hcnt; i++)
		error |= delq(hosts[i], pw->pw_name, argv[1], argv[2]);
	if(error) {
		gethostname(host, sizeof(host));
		delq(host, pw->pw_name, argv[1], argv[2]);
	}
}

delq(h, u, p, n)
register char *h, *u, *p, *n;
{
	struct sockaddr_in sin;
	register struct hostent *hp;
	int s, trys, i;

	if(!(hp = gethostbyname(h))) {
		fprintf(stderr, "%s: Unknown host?!?\n", h);
		return(1);
	}
	trys = 0;
	i = IPPORT_RESERVED - 1;
retry:
	if((s = rresvport(&i)) < 0) {
		perror("rresvport");
		return(1);
	}
	sin.sin_family = hp->h_addrtype;
	sin.sin_port = sp->s_port;
	bcopy(hp->h_addr, &sin.sin_addr, hp->h_length);
	if(connect(s, &sin, sizeof(sin))) {
		close(s);
		if(trys++ < 5) {
			sleep(trys);
			i--;
			goto retry;
		}
		perror("connect");
		return(1);
	}
	write(s, "\2", 1);
	write(s, u, strlen(u)+1);
	write(s, p, strlen(p)+1);
	write(s, n, strlen(n)+1);
	mode = QM_BACKGROUND;
	com(s, -1);
	close(s);
	return(0);
}
