/* Copyright 1990  The President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program for any
purpose and without fee is hereby granted, provided that this
copyright and permission notice appear on all copies and supporting
documentation, the name of Harvard University not be used in advertising
or publicity pertaining to distribution of the program, or to results
derived from its use, without specific prior written permission, and notice
be given in supporting documentation that copying and distribution is by
permission of Harvard University.  Harvard University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.	*/

/* cspawn.c - Dan Lanciani '85 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>

#include "queue.h"

cspawn(prog, v)
register char *prog, **v;
{
	register int pid;
	struct stat statb;
	struct rlimit rlimit;

	if(stat(prog, &statb))
		return(-1);
	if(chmod(prog, statb.st_mode | 0111))
		return(-1);
	if((pid = vfork()) < 0)
		return(-1);
	if(!pid) {
		if(maxcpu) {
			rlimit.rlim_cur = rlimit.rlim_max = maxcpu;
			setrlimit(RLIMIT_CPU, &rlimit);
		}
		if(minnice)
			nice(minnice);
		setuid(getuid());
		if(!getpgrp(0))
			setpgrp(0, getpid());
		execv(prog, v);
		exit(1);
	}
	chmod(prog, statb.st_mode);
	return(pid);
}
