
#ifndef lint
static char RCSid[] = "$Header: utmp.c,v 1.1 85/10/28 17:38:37 broome Exp $";
#endif

/*
 * $Log:	utmp.c,v $
 * Revision 1.1  85/10/28  17:38:37  broome
 * Initial revision
 */

#include "../common.h"
#include "defs.h"
#include <sys/stat.h>
#include <sys/file.h>
#include <utmp.h>


/*
 *   Routines for dealing with /etc/utmp.
 *
 *   We use a statically-allocated array because readutmp() is
 *   called at interrupt-level and we don't want to mess up malloc()
 *   and free as a result.
 */

#ifndef	LINELEN				/* length of line for "who()" */
#define	LINELEN		76		/* not 80 - for magic-cookie terminals */
#endif

#ifndef	MAXUSERS
#define	MAXUSERS	64
#endif

static	struct	utmp utbuf[MAXUSERS];				/* contents of file */
static	int		numents;							/* number of users on */
static	int		utfd;								/* file descriptor */


/*
 *  Initialize by opening the file and malloc'ing space.
 */

openutmp ()
{
	register	int i;
	struct		stat statb;

	if ((utfd = open ("/etc/utmp", O_RDONLY)) < 0) {
		perror ("can't open utmp");
		return;		/* exit?? */
	}
}


/*
 *  Reread /etc/utmp from the open file descriptor into the buffer.
 *  We test/set the "here" flag so we don't try to read at interrupt level
 *  if we're already doing it normally at the same time. (in "who()")
 */

readutmp ()
{
	static	int	here = 0;
	int	cc;

	if (here)
		return;
	here = 1;
	lseek (utfd, 0L, 0);	/* rewind */
	cc = read (utfd, utbuf, sizeof (utbuf));	/* and read */
	numents = cc / sizeof (struct utmp);
	here = 0;
}



/*
 *  Go through the utmp buffer, trying to find the named user,
 *  possibly with the tty specified.
 */

char *
findtty (user, tty, mode)
char *user;
char *tty;
int  *mode;
{
	static 		char   ttybuf[15];
	register	int    i;
	register	struct utmp *utmp;
	struct		stat   statb;

	*mode = NOT_ON;							/* start by assuming he's not on */
	for (i = 0; i < numents; i++) {
		utmp = &utbuf[i];
		if (*utmp->ut_name == '\0')              /* noone on this port */
			continue;
		if (strncmp (utmp->ut_name, user, 8))    /* names don't match */
			continue;
		if (tty && *tty && strncmp (tty, utmp->ut_line, 8)) /* not spec'd tty */
			continue;
		strcpy  (ttybuf, "/dev/");
		strncat (ttybuf, utmp->ut_line, 8);
		if (stat (ttybuf, &statb))	/* error on tty? */
			continue;
		if ((statb.st_mode & 02) == 0) {
			*mode = MESG_OFF;		/* refusing messages */
			if (tty && *tty)		/* they specified a particular tty */
				break;
			else
				continue;			/* see if we can find another one */
		} else {					/* all is okay, use this one */
			*mode = 0;
			return (ttybuf);
		}
	}
	return ((char *) 0);
}


/*
 *  Send a "who" message to the given address ...
 *  We go through the utmp buffer, building LINELEN-long buffers
 *  and send them on over to the user.
 */

who (sin)
struct sockaddr_in sin;
{
	register	struct	utmp *utmp;
	register	int		i;
	register	int		ulen;
	register	int		len = LINELEN + 1;
	register	int		users = 0;
	char		buf[LINELEN+5];		/* buffer for whole message */
	char		ubuf[20];			/* buffer for one user and tty */

#ifdef NO_WHO		/* not allowed here ... */
	sprintf (buf, "%c%c%cwho@%s: this site doesn't allow remote who.", 
				ESC, NAK, WHO, host);
	(void) sendto (misc, buf, strlen (buf), 0, &sin, sizeof (sin));
	return;
#else !NO_WHO	/* not so paranoid here */

	sprintf (buf, "%c%c%cwho info coming...", ESC, WHO, ACK);
	sendto (misc, buf, strlen (buf), 0, &sin, sizeof (sin));

	readutmp ();

	buf[0] = '\0';
	for (i = 0; i < numents; i++) {
		utmp = &utbuf[i];
		if (*utmp->ut_name == '\0')		/* noone on that line */
			continue;
		sprintf (ubuf, " %.8s(%.5s)", utmp->ut_name, utmp->ut_line);
		ulen = strlen (ubuf);
		if (ulen + len + 1 < LINELEN)
			strcat (buf, ubuf);
		else {
			if (users)
				(void) sendto (misc, buf, len+4, 0, &sin, sizeof (sin));
			sprintf (buf, "%c%c%cwho@%s:", ESC, MESSAGE, ACK, host);
			len = strlen (buf) - 4;
			strcat (buf, ubuf);
		}
		len += ulen;
		users++;
	}
	if (users == 0) {
		sprintf (buf, "%c%c%c%s: Noone logged on.", 
				ESC, MESSAGE, ACK, host);
		sendto (misc, buf, strlen (buf), 0, &sin, sizeof (sin));
	} else if (len)
		(void) sendto (misc, buf, len+4, 0, &sin, sizeof (sin));

#endif NO_WHO
}
