#ifndef lint
static char RCSid[] = "$Header: pagetty.c,v 1.1 85/10/28 17:38:31 broome Exp $";
#endif

/*
 * $Log:	pagetty.c,v $
 * Revision 1.1  85/10/28  17:38:31  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"
#include <sys/time.h>
#include <stdio.h>
#include <syslog.h>
#include <sys/file.h>


/*
 *  Page a local user to his terminal. 
 *  We compose the message, then send it 
 *  in one big block so as to minimise messing
 *  him up if he's in vi or the like.
 */

pagetty (inv, tty)
INV  *inv;
char *tty;
{
	struct  tm   *tm;
	long    now;
	char    buf[100], mesg[300];
	int     fd;		/* tty file descriptor */

	time (&now);
	tm = localtime (&now);

	/*  Now to compose the message  */
#ifdef notdef
	sprintf (buf, "\r\n\7Message from Phone_Daemon@%s at %d:%02d ...\r\n", 
				host, tm->tm_hour, tm->tm_min);
#endif
	sprintf (buf, "\r\n\7Message from the Telephone_Operator@%s at %d:%02d ...\r\n", 
				host, tm->tm_hour, tm->tm_min);
	strcpy (mesg, buf);

	sprintf (buf, "phone: connection requested by %s@%s\r\n", 
				inv->caller, inv->host);
	strcat (mesg, buf);

	sprintf (buf, "phone: respond with \"phone %s", inv->caller);
	strcat (mesg, buf);

	/* only list host if it differs from our own */
	if (strcmp (inv->host, host)) {
		strcat (mesg, "@");
		strcat (mesg, inv->host);
	}

	strcat (mesg, "\"\r\n\r\n\7");

	/*  And send it  */
	if ((fd = open (tty, O_WRONLY, 0444)) < 0) {   /* shouldn't happen */
		syslog (LOG_ERR, "phoned: can't open %s: %m", tty);
		_exit (-99);
	}
	
	(void) write (fd, mesg, strlen (mesg));
	(void) close (fd);

	_exit (0);
}
