#ifndef lint
static char RCSid[] = "$Header: page.c,v 1.1 85/10/28 17:38:29 broome Exp $";
#endif

/*
 * $Log:	page.c,v $
 * Revision 1.1  85/10/28  17:38:29  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"
#include <netdb.h>
#include <pwd.h>
#include <sys/time.h>

/*
 *   He wants us to page someone...
 *
 *   argv points to array like this: "callno : callee:tty:caller:conv_addr"
 *
 *   If we already have a call from the same address with the same call
 *   number then we assume it's a retransmission and just resend the
 *   same message-id (the one generated by us) and hope it will make 
 *   it to them.
 *
 *   We try to get the user's password entry so that we can
 *   look for a .busy forwarding file when we actually ring him.
 */

page (argv, sin)
char   *argv[];
struct sockaddr_in sin;
{
	long     now;
	register INV    *new;
	INV		 *seenit();
	struct   passwd  *pw, *getpwnam();
	struct   hostent *hp, *gethostbyaddr();

	/* first check to see if we already have the request */
	if (new = seenit (argv[0], sin)) {
		(void) sprintf (buf, "%c%c%c%s", ESC, PAGE, ACK, new->id);
		(void) sendto (misc, buf, strlen (buf), 0, &sin, sizeof (sin));
		return;
	}

	if (freelist) {
		new = freelist;			/* grab one from existing list */
		freelist = new->next;
		free (new->caller);		/* deallocate space from last time */
		free (new->callee);
		free (new->host);
		free (new->home);
		free (new->tty);
		free (new->convaddr);
		if (new->ptty)
			free (new->ptty);
	} else {			/* need to malloc new space */
		if ((new = (INV *) malloc (sizeof (INV))) == (INV *) 0) {
			perror ("malloc failed...");
			exit (1);
		}
	}

	new->callno   = strsave (argv[0]);		/* caller's form of call id */
	new->callee   = strsave (argv[1]);		/* person being called */
	new->tty      = strsave (argv[2]);		/* his tty */
	new->caller   = strsave (argv[3]);		/* caller name */
	new->convaddr = strsave (argv[4]);		/* conversation address */

	time (&now);

	/*  
	 *  Acknowledge immediately. We make an id 
	 *  from the lower 4 bits of the time.  
	 */

	sprintf (new->id, "%05ld", (now & 9999L));
	sprintf (buf, "%c%c%c%s", ESC, PAGE, ACK, new->id);
	sendto (misc, buf, strlen (buf), 0, &sin, sizeof (sin));

	/* figure out host name */
	if (hp = gethostbyaddr (&sin.sin_addr, sizeof (struct in_addr), AF_INET))
		new->host = strsave (hp->h_name);
	else
		new->host = strsave (inet_ntoa (sin.sin_addr.s_addr));

	/* save control address */
	bcopy ((char *)&sin, (char *)&new->ctladdr, sizeof (struct sockaddr_in));

	/* lookup callee in password file */
	if (pw = getpwnam (argv[0])) {
		new->home = strsave (pw->pw_dir);
		new->uid  = pw->pw_uid;
		new->gid  = pw->pw_gid;
	} else
		new->home = (char *) 0;

	new->rings  = 0;		/* so they get it next time around */
	new->ptty   = (char *) 0;
	new->prev   = NIL;

	insert (new);			/* and add to the pending list */
}


/*
 *  Search through the list of invitations, looking for one
 *  from the same address as this, with the same call number as well.
 */

INV *
seenit (callno, addr)
char   *callno;
struct sockaddr_in addr;
{
	register	INV	*inv;

	for (inv = invitations; inv; inv = inv->next)
		if (strcmp (callno, inv->callno) == 0 && 
			bcmp ((char *)&addr, (char *)&inv->ctladdr, 
			sizeof (struct sockaddr_in)) == 0)
				return (inv);
	return (NIL);
}

