#ifndef lint
static char RCSid[] = "$Header: main.c,v 1.1 85/10/28 17:38:28 broome Exp $";
#endif

/*
 * $Log:	main.c,v $
 * Revision 1.1  85/10/28  17:38:28  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"
#include <signal.h>
#include <stdio.h>
#include <syslog.h>
#include <netdb.h>

#ifdef FORK
#include <sys/ioctl.h>
#endif



char	myaddr[20];			/* internet host address in ascii dot notation */

/*
 *   Master phone daemon, sits on known socket address and
 *   listens for requests...  Handles invitations, acts as
 *   central clearinghouse for conversations.
 */

main (argc, argv)
int   argc;
char *argv[];
{
#if defined(SERVICES) && !defined(INETD)
	struct   servent *sp, *getservbyname();
#endif
	struct   sockaddr_in  sin;
	struct   hostent *hp, *gethostbyname();
	extern   int   ring();
	extern   int   sigchld();
	int      sock;
#ifndef INETD
	int      port = PORT;
#endif
	int      tty, i;

	invitations = NIL;
	freelist    = NIL;

#ifdef INETD
	if (argc != 1) {
		fprintf (stderr, "%s takes no options!\n", argv[0]);
		exit (1);
	}
#else  !INETD
	if (argc > 2) {
		fprintf (stderr, "Usage: %s [ port# ]\n", argv[0]);
		exit (1);
	}
#endif INETD

#ifndef INETD
	if (argc == 2) {
		if ((port = atoi (argv[1])) == 0) {
			fprintf (stderr, "Bad port number: %s\n", argv[1]);
			exit (1);
		}
	}
#endif INETD
#if defined(SERVICES) && !defined(INETD)
	else {
		if ((sp = getservbyname ("phone", "udp")) == (struct servent *) 0) {
			fprintf (stderr, "phone/udp: unknown service.\n");
			exit (1);
		}
		port = sp->s_port;
	}
#endif SERVICES

#ifndef INETD
	/*  Open and initialize the socket we will take requests on  */
	if ((sock = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror ("Cannot create datagram socket");
		exit (2);
	}
	bzero ((char *)&sin, sizeof (sin));
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons (port);
	sin.sin_family = AF_INET;

	if (bind (sock, &sin, sizeof (sin))) {
		perror ("Cannot bind datagram socket");
		exit (3);
	}
#else INETD
	sock = 0;			/* inetd hands us the first packet on stdin */
#endif INETD

	/*  Initialize the work socket as well  */
	if ((misc = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror ("Cannot create datagram work socket");
		exit (4);
	}
	bzero ((char *)&sin, sizeof (sin));
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = 0;
	sin.sin_family = AF_INET;
	if (bind (misc, &sin, sizeof (sin))) {
		perror ("Cannot bind datagram work socket");
		exit (5);
	}

	signal (SIGCHLD, sigchld);
	signal (SIGALRM, ring);
	gethostname (host, 32);

	if ((hp = gethostbyname (host)) == (struct hostent *) 0) {
		fprintf (stderr, "%s: cannot find my own address!!!\n", argv[0]);
		exit (6);
	}
	bcopy ((char *)hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
	strcpy (myaddr, inet_ntoa (sin.sin_addr.s_addr));

#if defined(FORK) && !defined(INETD)
	if (fork ())
		exit (0);

	if (sock != 0)
		close (0);
	i = open ("/dev/null", 0);
	if (sock != 1)
		dup2 (i, 1);
	if (sock != 2)
		dup2 (i, 2);

	if ((tty = open ("/dev/tty", 0)) != -1) {
		ioctl (tty, TIOCNOTTY);
		close (tty);
	} else 
		setpgrp (0, getpid ());
#endif FORK && !INETD

#ifdef LOG_ODELAY
	openlog ("phoned", LOG_PID | LOG_ODELAY, 0);
#else
	openlog ("phoned", LOG_PID, 0);
#endif
	openutmp ();

	service (sock);
	exit (0);
}


/*
 *  Main service routine.
 *  Listen on the socket, process requests.
 */

service (sock)
register int sock;
{
	int 		mask;		/* can't be in a register ... darn */
	int 		len;
	register	int  omask;
	register	int  rval;
	register	char *av[10];
	register	char buf[SIZ];
	register	int  i;
	struct		sockaddr_in sin;

	omask = 1 << sock;
	for ( ;; ) {
		mask = omask;
		if (select (32, &mask, 0, 0, 0) <= 0)
			continue;
		len = sizeof (sin);
		if ((rval = recvfrom (sock, buf, SIZ, 0, &sin, &len)) <= 0) {
			syslog (LOG_ERR, "recvfrom: %m");
			continue;
		}
		if (*buf != ESC)
			continue;
		buf[rval] = '\0';
		parse (buf+2, av);
		switch (buf[1]) {		/* figure out command */
			case PAGE:		page (av, sin);		break;
			case REINVITE:	reinvite (av, sin);	break;
			case INQUIRE:	inquire (av, sin);	break;
			case ANSWER:	answer (av);		break;
			case DAEMON:	daemon (sin);		break;
			case WHO:		who (sin);			break;
			case KILL:		exit (0);			break;
		}
	}
}


/*
 *  Parse the buffer into an argument vector.
 */

parse (buf, argv)
char  *buf;
char  **argv;
{
	register	char **ap;
	register	char *b;

	ap = argv;

	for (b = buf; b && *b && *b != '\n'; ) {
		*ap++ = b;
		for ( ; b && *b && *b != ':' && *b != '\n'; b++)
			;
		*b++ = '\0';
	}
	*ap = (char *) 0;
	return (ap - argv);
}
