/*
 * $Header: defs.h,v 1.1 85/10/28 17:38:15 broome Exp $
 */

/*
 * $Log:	defs.h,v $
 * Revision 1.1  85/10/28  17:38:15  broome
 * Initial revision
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>

#define SOCKADDR	struct sockaddr_in    /* shorter to type */

/*
 *   One of these structures is used for each pending invitation.
 */

struct invite {
	/*  info about the person requesting a call  */
	char      *caller;           /* login name of person making invitation */
	char      *host;             /* figured out from control port address  */
	SOCKADDR  ctladdr;           /* inviter's control port address         */
	char      *convaddr;         /* inviter's conversation port address    */
	char      *callno;			 /* unique per-user message id from caller */

	/*  info about the person being requested  */
	char      *callee;           /* login name of person being requested   */
	char      *tty;              /* user's tty, if any                     */
	char      *ptty;             /* tty we are actually paging             */
	char      *home;             /* his home directory                     */
	int       uid, gid;          /* used for forwarding programs           */

	/*  and bookkeeping information about the invitation itself  */
	int       type;              /* normal page or being forwarded?        */
	int       rings;             /* send a new ring when rings == 0        */
	int       pid;               /* child notification pid                 */
	int       flags;             /* various stuff about status             */
	char      id[10];			 /* identification for this request        */
	struct    invite *prev;      /* previous in doubly-linked list         */
	struct    invite *next;      /* next most recent invitation            */
};

typedef struct invite INV;
#define NIL       ((INV *) 0)
#define eq(a,b)   (strcmp(a,b) == 0)

/*  often-used functions  */
char    *malloc();
char    *strsave();
char    *findtty();
INV     *lookup();

#define SIZ 512
char    host[32];               /* name of this host */
char	buf[SIZ];				/* general-purpose buffer */
extern	int errno;
int		misc;					/* socket used to send out */

/*  Error return values from paging routines  */
#define NOT_HERE   1
#define ERR        3
#define THRESHOLD  (60*10)    /* ten minutes */

#define	PROG		(1<<0)		/* was forwarded to a program        */
#define FORWARD		(1<<1)		/* forwarded to another user/host    */
#define	DONTFORWARD	(1<<2)		/* forwarding failed - don't forward */
#define	NOT_ON		(1<<3)		/* user is not logged on */
#define	MESG_OFF	(1<<4)		/* user is refusing messages */

#define	BUSYFILE	"/.busy"	/* name of forwarding file */

INV		*invitations;			/* list of pending invitations */
INV		*freelist;				/* list of free invite structs */

