#ifndef lint
static char RCSid[] = "$Header: daemon.c,v 1.1 85/10/28 17:38:13 broome Exp $";
#endif

/*
 * $Log:	daemon.c,v $
 * Revision 1.1  85/10/28  17:38:13  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"
#include <stdio.h>
#include <syslog.h>


/*
 *  The guy wants a daemon, so give him one ...
 */

daemon (addr)
struct sockaddr_in addr;
{
	struct sockaddr_in sin;		/* address of new daemon */
	extern char myaddr[];		/* address of this host */
	char   *error();
	int    sock;
	int    pid;
	int    i, len;

	if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
		sprintf (buf, "%c%c%cCannot create socket: %s", 
					ESC, DAEMON, NAK, error());
		sendto (misc, buf, strlen (buf), 0, &addr, sizeof (addr));
		return;
	}

	i = 1;
	if (setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, &i, sizeof (i)))
		syslog (LOG_ERR, "daemon: setsockopt: %m");

	bzero ((char *)&sin, sizeof (sin));
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = 0;
	sin.sin_family = AF_INET;

	len = sizeof (sin);
	if (bind (sock, &sin, len) < 0) {
		sprintf (buf,"%c%c%cCannot bind socket: %s", ESC, DAEMON, NAK, error());
		sendto (misc, buf, strlen (buf), 0, &addr, sizeof (addr));
		return;
	}

	if (pid = fork ()) {		/* parent */
		if (pid == -1) {		/* failed */
			sprintf (buf, "%c%c%cFork failed: %s", ESC, DAEMON, NAK, error());
			sendto (misc, buf, strlen (buf), 0, &addr, sizeof (addr));
		} 
		(void) close (sock);
		return;
	}
	
	len = sizeof (sin);
	if (getsockname (sock, &sin, &len) < 0) {
		sprintf (buf, "%c%c%cCannot get socket name: %s", 
					ESC, DAEMON, NAK, error());
		(void) sendto (misc, buf, strlen (buf), 0, &addr, sizeof (addr));
		_exit (1);
	}

	/* life is good */
	sprintf (buf,"%c%c%c%s/%d", ESC, DAEMON, ACK, myaddr, ntohs (sin.sin_port));
	sendto (misc, buf, strlen (buf), 0, &addr, sizeof (addr));

	listen (sock, 5);

	if (sock != 0)
		if (dup2 (sock, 0)) {		/* set socket to be stdin */
			perror ("dup2");
			syslog (LOG_ERR, "daemon: dup2 failed: %m");
		}

	for (i = 1; i < getdtablesize(); i++)	/* close anything else */
		(void) close (i);
	
#ifdef DPATH		/* sure hope this is it! */
	execl (DPATH, "convd", 0);
#else !DPATH
	execl ("/usr/local/lib/convd", "convd", 0);
	execl ("/usr/lib/convd", "convd", 0);
	execl ("/etc/convd", "convd", 0);
#endif DPATH

#ifdef DPATH
	syslog (LOG_ERR, "cannot execl %s: %m", DPATH);
#else
	syslog (LOG_ERR, "cannot execl convd: %m");
#endif

	sprintf (buf, "%c%c%cExecl failed: %s", ESC, DAEMON, NAK, error());
	sendto (misc, buf, strlen (buf), 0, &addr, sizeof (addr));
	_exit (-99);
}


/*
 *  Return a string with the error message.
 */

char *
error ()
{
	extern int  errno;
	extern char *sys_errlist[];
	extern int  sys_nerr;

	if (errno > sys_nerr)
		return ("Unknown error.");
	else
		return (sys_errlist[errno]);
}
