#ifndef lint
static char RCSid[] = "$Header: child.c,v 1.1 85/10/28 17:38:11 broome Exp $";
#endif

/*
 * $Log:	child.c,v $
 * Revision 1.1  85/10/28  17:38:11  broome
 * Initial revision
 */

#include "../common.h"
#include "defs.h"
#include <sys/wait.h>


/*
 *   A more complicated sigchld handler -
 *   looks for the pid in the list of invitations
 *   and sends appropriate status messages to the callers.
 */

sigchld ()
{
	register INV *inv;
	union    wait status;
	char     mbuf[SIZ];
	int      pid;
	int      exitstat;

	while ((pid = wait3 (&status, WNOHANG, 0)) > 0) {	/* any children? */
		if (WIFSTOPPED (status)) {		/* shouldn't happen */
			kill (pid, 9);
			exitstat = 1;
		} else
			exitstat = status.w_retcode;

		for (inv = invitations; inv; inv = inv->next)
			if (inv->pid == pid)		/* does pid match? */
				break;
		if (inv->pid != pid)			/* didn't find child - continue */
			continue;

		if (exitstat && (inv->flags & PROG))		/* their program has problems */
			inv->flags |= DONTFORWARD;
		
		/*
		 *  Now send a message to the user.
		 *  The multiple sprintf()'s aren't very pretty ...
		 */
		
		if (exitstat == 0) {				/* good exit status - ok */
			sprintf (buf, "%s%sing user %s@%s",
						inv->id, (inv->flags & PROG) ? "Forward" : "Ring", 
						inv->callee, host);
			if ((inv->flags & PROG) == 0) {
				strcat (buf, " on ");
				strcat (buf, inv->ptty);
			}
		} else {
			sprintf (buf, "%sCannot ring %s@%s - Unknown error", 
						inv->id, inv->callee, host);
		}
		sprintf (mbuf, "%c%c%c%s", ESC, CALLING, exitstat ? NAK : ACK, buf);
		
		if (sendto (misc, mbuf, strlen (mbuf), 0, &inv->ctladdr,
					sizeof (inv->ctladdr)) < 0)
			perror ("child: sendto");
	}
}
