#include <pwd.h>

/*
 *  Expand a name containing a tilde to the full pathname.
 */

char *
exptilde (str)
char *str;
{
	char   buf[512];
	char   name[20];
	char   *i, *index();
	char   *getenv(), *strsave();
	struct passwd *pw, *getpwnam();

	if (*str != '~')				/* doesn't contain a tilde */
		return (strsave (str));

	if (i = index (str, '/'))		/* find slash, if any */
		*i = '\0';
	
	strcpy (name, str+1);			/* copy name after tilde */

	if (*name == '\0')				/* was "~/" */
		strcpy (buf, getenv ("HOME"));	/* so use our home */
	else {
		if ((pw = getpwnam (name)) == (struct passwd *) 0) {
			sprintf (buf, "Unknown user: %s", name);
			putmessage (buf);
			return ((char *) 0);
		}
		strcpy (buf, pw->pw_dir);	/* fill in that user's home */
	}
	if (i) {
		*i = '/';					/* and put back trailing pathname */
		strcat (buf, i);
	}
	return (strsave (buf));
}
