#include <signal.h>
#include <curses.h>
#include "defs.h"

/*
 *  Routine to handle SIGTSTP and the like.
 */

sigstop ()
{
	extern  int stream;
	extern  int maxy;
	int     (*func)();

	func = signal (SIGTSTP, SIG_DFL);		/* save old SIGTSTP routine */

	if (Stop)
		(void) write (stream, "\n[ Stopped ]", 12);

	tstp ();						/* curses routine to stop and restart */

	if (Stop)
		(void) write (stream, "\r\f", 2);	/* clear this line */

	signal (SIGTSTP, func);			/* and restore SIGTSTP routine */
}
