#include <signal.h>
#include <sys/ioctl.h>

/*
 *  Interrupt handler - if we have a child, kill it off, else exit.
 */

sigint ()
{
	extern   int	tochild, fromchild;
	extern   int	childpid;
	extern   int	killedchild;
	extern   int	connected;
	extern   int	did_screen;
	unsigned char c;

	if (childpid > 0) {
		kill (childpid, SIGHUP);	/* it's sure to die sooner or later!!! */
		kill (childpid, SIGINT);
		kill (childpid, SIGKILL);
		killedchild = 1;
		putmessage ("Child has been killed!!!!");
	} else {
		if (connected && did_screen) {
			putmessage ("Really quit? ");
			read (0, &c, 1);
			c &= 0177;
			if (c == 'y' || c == 'Y')
				quit ();
			putmessage (" ");
		} else {
			quit ();
		}
	}
}


/*
 *  Sigquit handler - save a copy of the screen into a ".dump" file.
 */

sigquit ()
{
	dodump (".dump");
}


#ifdef vax

/*
 *  Generic bad signal handler. Very non-portable,
 *  at least according to the documentation.
 */

badsig (sig)
int sig;
{
	char  *s;

	cleanup ();

	switch (sig) {
		case SIGHUP:	s = "SIGHUP";	break;
		case SIGINT:	s = "SIGINT";	break;
		case SIGQUIT:	s = "SIGQUIT";	break;
		case SIGILL:	s = "SIGILL";	break;
		case SIGTRAP:	s = "SIGTRAP";	break;
		case SIGIOT:	s = "SIGIOT";	break;
		case SIGEMT:	s = "SIGEMT";	break;
		case SIGFPE:	s = "SIGFPE";	break;
		case SIGKILL:	s = "SIGKILL";	break;
		case SIGBUS:	s = "SIGBUS";	break;
		case SIGSEGV:	s = "SIGSEGV";	break;
		case SIGSYS:	s = "SIGSYS";	break;
		case SIGPIPE:	s = "SIGPIPE";	break;
		case SIGALRM:	s = "SIGALRM";	break;
		case SIGTERM:	s = "SIGTERM";	break;
		case SIGURG:	s = "SIGURG";	break;
		case SIGSTOP:	s = "SIGSTOP";	break;
		case SIGTSTP:	s = "SIGTSTP";	break;
		case SIGCONT:	s = "SIGCONT";	break;
		case SIGCHLD:	s = "SIGCHLD";	break;
		case SIGTTIN:	s = "SIGTTIN";	break;
		case SIGTTOU:	s = "SIGTTOU";	break;
		case SIGIO:		s = "SIGIO";	break;
		case SIGXCPU:	s = "SIGXCPU";	break;
		case SIGXFSZ:	s = "SIGXFSZ";	break;
		case SIGVTALRM:	s = "SIGVTALRM";	break;
		case SIGPROF:	s = "SIGPROF";	break;
		case SIGWINCH:	s = "SIGWINCH";	break;
		case SIGUSR1:	s = "SIGUSR1";	break;
		case SIGUSR2:	s = "SIGUSR2";	break;
	}
	printf ("\r\n\r\nCaught %s signal!!!! Exiting...\r\n\r\n", s);
	exit (1);
}

#else

badsig ()
{
	cleanup ();
	printf ("\r\n\r\nCaught an unknown bad signal! Exiting ...\r\n\r\n");
	exit (1);
}

#endif vax
