#include "defs.h"
#include <sys/time.h>

#define	WAIT	2		/* wait this long before re-sending */

/*
 *  Send the given buffer to the given address, with
 *  multiple retries.  Stores the received string
 *  in the global `buf', and returns the number of chars
 *  read, or -1 on error or no response.
 */

sendit (str, len, sin)
char   *str;
int    len;
struct sockaddr_in sin;
{
	struct	timeval timeout;
	int		rval;		/* number of bytes read */
	int		mask;		/* used for select */
	int		tries;		/* number of tries made */
#ifdef DEBUG
	char	mbuf[100];	/* message buffer */
#endif

	timeout.tv_sec  = WAIT;
	timeout.tv_usec = 0;

	for (tries = 0; tries < 5; tries++) {
		if (sendto (ctl, str, len, 0, &sin, sizeof (sin)) < 0) {
			error (0, "sendit: sendto");
			return (-1);
		}
		if (Debug)
			printf ("\r\nsendit: trying #%d.\r\n", tries);
#ifdef DEBUG
		sprintf (mbuf, "sendit: trying #%d ...", tries);
		putmessage (mbuf);
#endif DEBUG
		mask = 1 << ctl;
		if (select (32, &mask, 0, 0, &timeout) <= 0) {	/* nothing to read on */
			if (Debug)
				printf ("\r\nsendit: no response on try #%d.\r\n", tries);
			continue;
		}
		rval = read (ctl, buf, BUFFER);		/* read the response */
		if (rval < 0) {
			error (0, "sendit: read response");
			continue;
		}
		if (Debug)
			printf ("sendit: read %d chars.\r\n", rval);
		return (rval);
	}
	if (Debug)
		printf ("\r\nsendit: response timed out.\r\n");
#ifdef DEBUG
	putmessage ("sendit: response timed out.");
#endif DEBUG
	return (-1);		/* timed out */
}
