#include "../common.h"
#include "defs.h"
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>			/* these two are for wait3() */
#include <sys/resource.h>
#include <fcntl.h>
#include <errno.h>
#include <curses.h>

/*
 *  Routines to handle subprocesses inside windows.
 *
 *  Future plans include putting children on ptys,
 *  allowing multiple processes, some kind of simple
 *  process control, setting window size (ioctl) and 
 *  termcap to properly reflect the window size, and 
 *  being able to run screen-oriented programs within
 *  the phone window.  Maybe sometime ...
 */


int	childpid = 0;		/* current child process's pid */
int tochild;			/* fd to write to child */
int fromchild;			/* fd to read from child */
int	killedchild;		/* flag set on intr - flush output */ 


/*
 *   Run a program. We use the user's shell to allow piping and wildcards.
 */

run (argc, argv)
int      argc;
char    *argv[];
{
	char  args[512];
	int   in[2], out[2];
	int   i;

	if (childpid) {
		putmessage ("You are already running a program!!!");
		return;
	}

	/* concatenate all the arguments to pass to a shell */
	for (*args = '\0', i = 0; i < argc; ) {
		strcat (args, argv[i]);
		if (++i < argc)
			strcat (args, " ");
	}

	if (pipe (in) < 0 || pipe (out) < 0) {
		error (0, "Cannot pipe to child process");
		return;
	}
	killedchild = 0;

	switch (childpid = fork ()) {
		case -1:	error (0, "fork");	break;

		case  0:	(void) dup2 (in[0], 0);	/* child's stdin */
					(void) dup2 (out[1], 1);	/* stdout */
					(void) dup2 (out[1], 2);	/* stderr */
					(void) close (in[0]); (void) close (out[1]);
					execl (shell, basename (shell), "-c", args, (char *) 0);
					perror (argv[0]);
					exit (1);

		default:	(void) close (in[0]);
					(void) close (out[1]);
					(void) fcntl (in[1],  F_SETFL, FNDELAY | FASYNC);
					(void) fcntl (out[0], F_SETFL, FNDELAY | FASYNC);
					tochild = in[1];	/* write to child here */
					fromchild = out[0];	/* read from child here */
					return;
	}
}


/*
 *   Read some output from the process.  We make sure that there
 *   aren't any magic characters there to hang anyone, and do
 *   local echoing if need be.
 */

readchild ()
{
	int  r, i;
	char buf[1024];
	register char *c;
	extern int errno, stream;

	if ((r = read (fromchild, buf, 1024)) == -1) {
		if (errno != EWOULDBLOCK)
			perror ("read from child");
		return;
	} else if (r == 0) {		/* child is finished */
		if (Debug)
			putmessage ("Saw EOF on child process.");
		childpid = 0;
		(void) close (tochild);
		(void) close (fromchild);
	} else {					/* send to everyone */
		if (!killedchild) {
#ifdef LOCAL_ECHO
			int oldwin = selwin (0);
#endif LOCAL_ECHO
			for (c = buf, i = 0; i < r; c++, i++) {
				if (*c & META)
					*c &= 0177;
#ifdef LOCAL_ECHO
				showch (*c);
#endif LOCAL_ECHO
			}
			(void) write (stream, buf, r);
#ifdef LOCAL_ECHO
			refresh ();
			(void) selwin (oldwin);
#endif LOCAL_ECHO
		}
	}
}


/*
 *  SIGCHLD handler.
 *  We don't reset the pid and fd states because we'll get those when
 *  we see the eof on the kid's descriptors.
 */

sigchld ()
{
	union  wait status;

	if (childpid == 0)
		return;

	while (wait3 (&status, WNOHANG, (struct rusage *) 0) > 0)
		;

	if (Debug)
		putmessage ("Caught sigchld.");
}
