#include "../common.h"
#include "defs.h"
#include <stdio.h>
#include <signal.h>
#include <errno.h>

#define	toggle(var)	var = !var

struct	sockaddr_in	locaddr;	/* our own host address */
char	buf[BUFFER];			/* general purpose character buffer */
char	convaddr[25];			/* address of our conversation in ascii */
char	host[32];				/* local host name */
char	realname[100];			/* user's real name from password file */
extern	int users;				/* number of users connected - from windows.c */
int		pending;				/* number of pending calls */
int		changed_size;			/* caught SIGWINCH, need to resize windows */

main (argc, argv)
int   argc;
char *argv[];
{
	int		answer = 0;
	int		smask;				/* saved socket select mask */
	extern	int errno;
	extern	int timer();
	extern	int quit();
	extern	int badsig();
	extern	int sigint();
	extern	int sigquit();
	extern	int sigstop();
	extern	int sigwinch();
	extern	int sigchld();
	char	*check_invite();
	char	*getdaemon();
	char	*index();
	char	*user;				/* name of user we are trying to call */
	char	*hishost;			/* and his hostname */
	char	*addr;				/* address of conversation from getdaemon () */
	struct	sockaddr_in sin;

	argv++, argc--;

	while (*argv && **argv == '-') {
		while (*++*argv) {
			switch (**argv) {
				case 'a':	if (argc > 1) {		/* given an address */
								addr = *++argv;
								argc--; 
								printf ("Using address \"%s\"\n", addr);
							}
							break;
				case 'b':	toggle (Bells);		break;
				case 'd':	toggle(Debug);		break;
				case 'i':	toggle(Inverse);	break;
			}
		}
		argv++, argc--;
	}

	if (argc == 0)		/* just answer incoming calls */
		answer = 1;
	else if (argc > 2) {
		fprintf (stderr, "Usage: %s [-{bdi}] user@host [ tty ]\n", *argv);
		exit (1);
	}

	if (names ())		/* get all the various info */
		exit (1);
	readrc ();			/* read in and act on the .phonerc */

	if (!answer) {		/* expand any user aliases and see who we're calling */
		if ((user = expalias (argv[0])) == (char *) 0)
			user = argv[0];
		if (hishost = index (user, '@'))
			*hishost++ = '\0';
		else
			hishost = host;
	}

	connected = 0;
	pending = 0;

	/*  set up all the signals  */
	signal (SIGPIPE,  SIG_IGN);
	if (!Debug) {
		signal (SIGHUP,   badsig);
		signal (SIGBUS,   badsig);
		signal (SIGSEGV,  badsig);
	}
	signal (SIGALRM,  timer);
	signal (SIGQUIT,  sigquit);
	signal (SIGINT,   sigint);
#ifdef SIGWINCH
	signal (SIGWINCH, sigwinch);
#endif 
	signal (SIGCHLD,  sigchld);

	/*  
	 *	open datagram control socket.
	 */

	if ((ctl = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
		error (1, "Can't get control socket");

	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = 0;
	sin.sin_family = AF_INET;

	if (bind (ctl, &sin, sizeof (sin)) < 0)
		error (1, "Can't bind control socket");

	setup ();		/* initialize all the screen stuff */

	/*  Have we been invited ???  */
	if (addr || (addr = check_invite (answer ? "*" : user, hishost))) {
		if (Debug)
			printf ("\r\nCheck_invite returned \"%s\"\r\n", addr);
		connect_daemon (addr);
		if (!connected) {
			if (Debug)
				printf ("Connection failed.\r\n");
			goto again;		/* caller has hung up !!! */
		}
	} else {
again:
		if (Debug)
			printf ("\r\nCheck_invite returned no address.\r\n");
		if (answer) {	/* don't want to place a call */
			fprintf (stderr, "\r\nNo pending calls for %s\r\n", login);
			cleanup ();
			exit (1);
		}
		do {
			putmessage ("");
			if ((addr = getdaemon()) == (char *) 0)
				error (1, "Cannot get conversation daemon address");
			if (Debug)
				printf ("\rGet_daemon returned address of \"%s\"\r\n", addr);
			connect_daemon (addr);
			if (!connected) {
				putmessage ("Trying to connect to conversation daemon.");
				printf ("Trying to connect to conversation daemon.");
				fflush (stdout);
			}
		} while (!connected);
		placecall (user, hishost, argv[1] ? argv[1] : "");
	}

	smask = (1 << 0) | (1 << ctl) | (1 << stream); 
	alarm (1);		/* get things rolling */

	/*
	 *  Main loop - select on sockets and handle appropriately.
	 */

	for ( ;; ) {
		static int mask;
		extern int childpid, fromchild;
#ifdef SIGWINCH
		if (changed_size) {		/* caught SIGWINCH - have to resize windows */
			stretch (1);
			changed_size = 0;
		}
#endif
		mask = smask;
		if (childpid)
			mask |= 1 << fromchild;
		if (select (32, &mask, 0, 0, 0) <= 0) {
			if (errno == EINTR)
				continue;
			error (1, "select");
		}
		errno = 0;
		if (mask & (1 << 0))
			keyboard ();
		if (mask & (1 << stream))
			readstream ();
		if (mask & (1 << ctl))
			readctl ();
		if (childpid && (mask & (1 << fromchild)))
			readchild ();
	}
	/*NOTREACHED*/
}
