#include "../common.h"
#include "defs.h"

#include <signal.h>
#include <stdio.h>
#include <netdb.h>


/*
 *  Connect to the conversation daemon.
 *  Addrstr is a string containing the intended address
 *  in the form "128.32.149.2/9535".
 */

connect_daemon (addrstr)
char *addrstr;
{
	struct  sockaddr_in addr;
	char	*inet_ntoa();
	char    *p, *index();
	char	str[30];
	int     oldval;
	int     (*oldfunc)();
	int     timeout();

	if (addrstr == (char *) 0 || *addrstr == '\0')
		error (1, "Failed to connect to conversation daemon");

	oldval = alarm (0);		/* turn off alarms and save old value */

#ifdef SLAVE
	if (*addrstr == 'y' || *addrstr == 'n')
		addrstr++;
#endif SLAVE

	strcpy (convaddr, addrstr);		/* save the current conversation address */
	strcpy (str, addrstr);			/* and use 'str' for our working copy */

	if (p = index (str, '/'))		/* find slash before port number */
		*p++ = '\0';

	if ((stream = socket (AF_INET, SOCK_STREAM, 0)) < 0)
		error (1, "Cannot open stream socket");

	bzero ((char *)&addr, sizeof (addr));		/* connect trashes the args */
	addr.sin_addr.s_addr = inet_addr (str);
	addr.sin_port = htons (atoi (p));
	addr.sin_family = AF_INET;

	oldfunc = signal (SIGALRM, timeout);		/* save old handler */
	alarm (15);									/* timeout in five seconds */

	if (Debug) {
		printf ("Trying to connect to conversation daemon.\r\n");
		fflush (stdout);
	}

	if (connect (stream, (char *)&addr, sizeof (struct sockaddr_in)) < 0) {
		alarm (0);
		close (stream);
		connected = 0;
		if (Debug)
			printf ("\r\n\r\nNot connected.\r\n");
	} else {									/* say hello */
		if (Debug) {
			printf ("Connected to conversation daemon @ \"%s\"\r\n", convaddr);
			fflush (stdout);
		}
		sprintf (buf, "%s:%s:%s:%s", login, host, tty, realname);
		if (write (stream, buf, strlen (buf)) < 0)
			error (1, "getdaemon: cannot write stream socket");
		connected = 1;
	}

	/*
	 *  Tell the local phoned to delete our invitaton now
	 *  that we've answered it. Not used yet.
	 */

#ifdef notdef
	sprintf (buf, "%c%c%s:%s", ESC, ANSWER, login, convaddr);
	(void) sendto (ctl, buf, strlen (buf), 0, &locaddr, sizeof (locaddr));
#endif notdef

	(void) alarm (oldval);					/* restore old alarm value */
	(void) signal (SIGALRM, oldfunc);		/* and handler routine */

	return (!connected);
}


timeout ()
{
	putmessage ("cannot connect to conversation daemon: connection timed out.");
}
