/*
 *  All the (external) command functions.
 */

extern int
	alias(), cancel(), cd(), dump(), help(), page(), quit(), 
	run(), set(), show(), longhelp(), who(), zip();

static char aliashelp[]  = "Assign an alias to a user name";
static char cancelhelp[] = "Cancel a pending call to user";
static char cdhelp[]     = "Change the working directory";
static char	dumphelp[]   = "Save a copy of the screen image into a file";
static char helphelp[]   = "See help messages for any command";
static char pagehelp[]   = "Invite user to join the conversation";
static char quithelp[]   = "Leave the current conversation";
static char runhelp[]    = "Run a program within the window";
static char sethelp[]    = "Set the value of a variable";
static char showhelp[]   = "See the value of a variable";
static char whohelp[]    = "See who is currently logged on";

static struct cmd {
	char	*name;			/* name this command goes by */
	int		(*func)();		/* function to handle it     */
	int		minargs;		/* minimum number of args    */
	int		maxargs;		/* maximum number of args    */
	char	*usage;			/* usage message text        */
	char	*help;			/* help message text         */
} cmds [] = {
	{ "call",	page,	2,	3,	"user@host [tty]",		pagehelp	},
	{ "page",	page,	2,	3,	"user@host [tty]",		pagehelp	},
	{ "phone",	page,	2,	3,	"user@host [tty]",		pagehelp	},
	{ "cancel",	cancel,	2,	3,	"user@host [tty]",		cancelhelp	},
	{ "quit",	quit,	1,	1,	"",						quithelp	},
	{ "who",	who,	1,	2,	"[user]",				whohelp		},
	{ "?",		help,	1,	2,	"[command]",			helphelp	},
	{ "help",	help,	1,	2,	"[command]",			helphelp	},
	{ "set",	set,	2,	3,	"variable [value]",		sethelp		},
	{ "show",	show,	1,	98,	"[var [var]]",			showhelp	},
	{ "!",		run,	2,	98,	"prog [args]",			runhelp		},
	{ "run",	run,	2,	98,	"prog [args]",			runhelp		},
	{ "dump",	dump,	1,	2,	"[file]",				dumphelp	},
	{ "cd",		cd,		1,	2,	"[directory]",			cdhelp		},
	{ "alias",	alias,	1,	3,	"[alias user]",			aliashelp	},
	{ "accept",	zip,	1,	99,	"",						""			},
	{ "forward",zip,	1,	99,	"",						""			},
	{ 0,		0,		0,	0,	0,						0			}
};


/*
 *  Given a buffer, parse it and execute the command.
 */

execute (buf)
char    *buf;
{
	int		len;
	int		argc;
	char	*argv[99];
	char	line[80];
	struct	cmd *cmd;

	if ((argc = parse (buf, argv)) == 0)   /* null command */
		return;
	
	len = strlen (argv[0]);

	for (cmd = cmds; cmd->name; cmd++) {
		if (strncmp (argv[0], cmd->name, len))  /* is it a prefix? */
			continue;
		if (argc < cmd->minargs || argc > cmd->maxargs) {
			sprintf (line, "%s: bad number of arguments - usage: %s %s",
						cmd->name, cmd->name, cmd->usage);
			putmessage (line);
		} else 
			(*cmd->func)(argc-1, argv+1);
		return;
	}
	sprintf (line, "Unknown command: \"%s\" - try \"?\" for list of commands",
				argv[0]);
	putmessage (line);
}


/*
 *  Print a help message for the given command, or all commands.
 */

help (argc, argv)
int   argc;
char *argv[];
{
	struct cmd *cmd;
	char   buf[80];
	int    all = (argc == 0);
	int    len;

	if (all)
		message ("Showing help for all commands. Commands may be abbreviated.");
	else
		len = strlen (argv[0]);
	
	for (cmd = cmds; cmd->name; cmd++)
		if (all || strncmp (argv[0], cmd->name, len) == 0) {
			if (!all || strcmp (cmd->help, (cmd+1)->help)) {
				sprintf (buf, "help: %s: %s.", cmd->name, cmd->help);
				message (buf);
			}
		}
}


/*
 *  Do nothing. Used for commands in .phonerc that have 
 *  no meaning to the client process.
 */

zip ()
{
	;
}
