#include "../common.h"
#include "defs.h"
#include <curses.h>

/*
 *  Read and process some characters from the stream socket.
 *
 *  Commands are passed in one byte by setting the high bit
 *  with info encoded in the following manner:
 *
 *       +---+-------+-------------------+
 *  Bit: | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *       +---+-------+-------------------+
 *       | 1 |  cmd  |   window number   |
 *       +---+-------+-------------------+
 *
 *  For the "set update" command, only the low bit of the window 
 *  number is used, to indicate whether updating should be on or off.
 */

#define	WINMASK		((1<<4)|(1<<3)|(1<<2)|(1<<1)|(1<<0)) /*037*/					/* lower 5 bits (0-4) set */
#define	CMDMASK		((1<<6)|(1<<5))		/* only bits 5 and 6 set */


readstream ()
{
	static		int   adding = 0;		/* reading an "adduser" string? */
	static		char  combuf[512];		/* command mode buffer */
	char  		buf[512];				/* normal input buffer */
	register	char  *bufptr;			/* pointer into normal buffer */
	static		char  *comptr;			/* pointer into command mode buffer */
	register	int   i, r;
	register	int   c;
	static		int   addslot = 0;		/* slot for adduser() */
	static		int   dorefresh = 0;
	static		int   noupdate = 0;		/* don't refresh screen until told to */

	if ((r = read (stream, buf, 512)) == 0) {	/* daemon hung up */
		quit ();
		connected = 0;
		return;
	}

	bufptr = buf;
	for (i = 0; i < r; i++) {		/* go through each character */
		c = *bufptr++;
		if (c & META) {				/* a command byte */
			switch (c & CMDMASK) {
				case ADDUSER:		/* add a new user */
							comptr = combuf;
							adding = 1;
							addslot = c & WINMASK;
							break;
				case DELUSER:		/* delete an existing user */
							deluser (c & WINMASK);
							break;		
				case UPDATE:		/* set screen updating */
							if (c & 01)		/* turn updating on */
								noupdate = 0;
							else			/* turn it off */
								noupdate = 1;
							break;
				default:			
							if (adding) {	/* end of adduser cmd */
								*comptr = '\0';
								adduser (addslot, combuf);
								adding = 0;
								dorefresh = 1;
							} else			/* select current window */
								selwin (c & WINMASK);
							break;		
			}
		} else {						/* normal character */
			if (adding)					/* add to adduser buffer */
				*comptr++ = c;
			else {						/* add to display */
#ifdef LOCAL_ECHO
				extern int current;			/* defined in windows.c */
				if (current != 0 || !Echo){	/* only show if it's not ours */
#endif
					showch (c);
					dorefresh = 1;
#ifdef LOCAL_ECHO
				}
#endif
			}
		}
	}
	if (dorefresh && noupdate == 0) {
		refresh ();
		dorefresh = 0;
	}
	return;
}
