#include "../common.h"
#include "defs.h"
#include <netdb.h>
#include <stdio.h>
#include <pwd.h>

#undef	NULL
#define	NULL ((char *) 0)

/*
 *  Initialize all the various names and such that we all want to know.
 */

names ()
{
	struct	passwd	*pw, *getpwnam();
	struct	hostent	*hp, *gethostbyname();
#ifdef SERVICES
	struct	servent *sp, *getservbyname();
#endif
	extern	char	*getlogin();
	extern	char	*ttyname();
	extern	char	*getenv();
	extern	char	realname[];
	char	*r, *p, *n;

	if ((pw = getpwuid (getuid ())) == (struct passwd *) 0) {
		fprintf (stderr, "Who are you?\n");
		return (1);
	}

	if ((n = getlogin ()) == NULL)		/* in a window? */
		login = strsave (pw->pw_name);	/* use our acct name */
	else
		login = strsave (n);

	if ((home = getenv ("HOME")) == NULL)
		home = pw->pw_dir;

	if ((shell = getenv ("SHELL")) == NULL)
		shell = "/bin/sh";

	if (p = getenv ("NAME"))
		strcpy (realname, p);
	else {
		for (p=pw->pw_gecos, r=realname; p && *p && *p!=',' && *p!=';'; p++) {
			if (*p == '&') {		/* copy in from login name */
				n = pw->pw_name;	/* and grab the login name */
				if ('a' <= *n && *n <= 'z')	/* capitalize the first character */
					*n += 'A' - 'a';
				while (*n)
					*r++ = *n++;
			} else
				*r++ = *p;
		}
		*r = '\0';
	}

	if ((tty = ttyname (0)) == NULL || !isatty (1)) {
		fprintf (stderr, "Input must be a terminal, not a file or pipe.\n");
		return (1);
	}
	tty = strsave (tty);
	if (strncmp (tty, "/dev/", 5) == 0)
		tty += 5;	/* skip over "/dev/" */
 
	/* find out about our host */
	gethostname (host, 32);
	if ((hp = gethostbyname ("localhost")) == (struct hostent *) 0)
		if ((hp = gethostbyname (host)) == (struct hostent *) 0) {
			fprintf (stderr, "Cannot find network entry for %s\n", host);
			return (1);
		}
	bzero ((char *)&locaddr, sizeof (locaddr));
	bcopy ((char *)hp->h_addr, (char *)&locaddr.sin_addr, hp->h_length);
	locaddr.sin_family = hp->h_addrtype;

#ifdef SERVICES
	if ((sp = getservbyname ("phone", "udp")) == (struct servent *) 0) {
		fprintf (stderr, "This machine doesn't support \"phone\"\r\n");
		return (1);
	}
	locaddr.sin_port = port = sp->s_port;
#else  SERVICES
#ifdef PORT
	locaddr.sin_port = port = htons (PORT);
#else /* PORT */
	fprintf (stderr, 
		"Your site administrator screwed up installing this program!!!\r\n");
	return (1);
#endif PORT
#endif SERVICES

	return (0);
}
