#include <sys/ioctl.h>
#include <curses.h>
#undef   ctrl()

#include "defs.h"

/*
 *  Handle keyboard input.
 *
 *  Need to handle edit character mapping --- see if char is one
 *  of his edit characters, swap to standard character.
 */

static struct key {
	int		his;		/* his key */
	int		std;		/* what we'll map it to */
} keys [] = {
	{ ctrl(M),	ctrl(J) },		/* <cr> -> newline */
	{ 0, 		ctrl(H) },		/* backspace */
	{ 0, 		ctrl(W) },		/* word erase */
	{ 0, 		ctrl(X) },		/* line kill */
	{ 0, 		0       }
};


keyboard ()
{
	static   char   c;              /* character read in    */
	register int 	k;				/* for doing key maps   */
	static   int    command = 0;	/* on bottom line?      */
	static   int    cpos = 0;		/* position in buffer   */
	static   char   cbuf[80];		/* and command buffer   */
	extern   int	childpid, tochild;
	static	 int y, x;

	if (read (0, &c, 1) != 1)
		return;
	
	/*
	 *  We remap the basic editing characters here to make life easier later.
	 */

	for (k = 0; k < 4; k++) {
		if (keys[k].his == c) {
			c = keys[k].std;
			break;
		}
	}

	if (c == ctrl(L) || c == ctrl(R)) {
		wrefresh (curscr);
		return;
	}

	if (c == ESC) {				/* toggle command mode */
		getyx (stdscr, y, x);	/* save the current cursor position */
		move (maxy, 0);			/* jump to bottom line */
		clrtoeol ();
		command = !command;		/* toggle mode */
		if (command)			/* entering command mode  */
			addstr (PROMPT);
		cpos = 0;				/* and reset buffer index */
		move (y, x);			/* restore cursor position */
		refresh ();
		return;
	} 

	if (command == 0) {						/* not in command mode */
		if ((c == ctrl(D)) && childpid) 	/* send eof to child */
			close (tochild);
		if (childpid == 0 || Echo) {		/* send char to the socket */
#ifdef LOCAL_ECHO
			int old = selwin (0);
			showch (c);
			selwin (old);
			refresh ();
#endif LOCAL_ECHO
			(void) write (stream, &c, 1);
		}
		if (childpid && !Hold)				/* and to child process */
			(void) write (tochild, &c, 1);
		return;
	} else {

		/* 
		 *    The rest is command-mode processing where 
		 *    we fiddle with the command buffer. This 
		 *    should move to a separate routine somewhere.
		 */

		getyx (stdscr, y, x);		/* save the current cursor position */
		if (c == ctrl(J)) {			/* execute the buffer */
			cbuf[cpos] = '\0';		/* null-terminate it  */
			move (maxy, 0);			/* go to beginning of line */
			clrtoeol ();			/* clear line to end  */
			refresh ();				/* update the screen  */
			if (cpos)
				execute (cbuf);		/* and execute it !!! */
			command = cpos = 0;		/* turn off command mode */
			move (y, x);			/* restore cursor position */
			refresh ();
			return;					/* and we're done */
		}

		/*
		 *  The message() routine modified the bottom line,
		 *  so reprint whatever should be down there.
		 */

		if (touched25) {
			move (maxy, 0);			/* go to beginning of line */
			addstr (PROMPT);		/* print prompt */
			cbuf[cpos] = '\0';
			addstr (cbuf);			/* and print buffer */
			clrtoeol ();
			touched25 = 0; 
		}

		move (maxy, strlen (PROMPT) + cpos);

		/*
		 *  If we're here, then we want to add the character to
		 *  the pending command buffer.
		 */

		switch (c) {
			case ctrl(H):	/* backspace */
							if (cpos) {
								cpos--;
								addstr ("\b \b");
							}
							break;

			case ctrl(W):	/* word erase */
							while (--cpos >= 0) {
								if (cbuf[cpos] != ' ') {
									cpos++;
									break;
								}
								addstr ("\b \b");
							}
							while (--cpos >= 0) {
								if (cbuf[cpos] == ' ') {
									cpos++;
									break;
								}
								addstr ("\b \b");
							}
							break;

			case ctrl(U):	/* line kill */
			case ctrl(X):	move (maxy, strlen (PROMPT));
							clrtoeol ();
							cpos = 0;
							break;

			case ctrl(I):	/* tab */
							c = ' ';     /* fall through ... */
			default:		cbuf[cpos++] = c;
							addch (c);
							break;
		}
		cbuf[cpos] = '\0';
		move (y, x);			/* restore cursor position */
		refresh ();
		return;
	}
}


/*
 *   Get our editing characters. Called by setup().
 */

geteditchars ()
{
	struct sgttyb  chars;		/* standard char- and line-erase */
#ifdef TIOCGLTC
	struct ltchars lchars;		/* local - word-erase */
#endif

	if (ioctl (0, TIOCGETP, &chars) < 0) {
		error (0, "ioctl (TIOCGETP) failed");
		return;
	}
	keys[1].his = chars.sg_erase;
	keys[3].his = chars.sg_kill;

#ifdef TIOCGLTC
	if (ioctl (0, TIOCGLTC, &lchars) < 0) {
		error (0, "ioctl (TIOCGLTC) failed");
		return;
	}
	keys[2].his = lchars.t_werasc;
#endif
}
