#include "../common.h"
#include "defs.h"

/*
 *  Check to see if we have any pending invitations from the named user.
 *  Returns the string containing our given address (or NULL)
 */

/*ARGSUSED*/
char *
check_invite (user, host)
char *user;
char *host;
{
	struct  sockaddr_in sin;	/* address of daemon socket */
	char    mbuf[80];			/* one line of incoming message  */
	int     r, tries;

	/*  socket address "locaddr" is already initialised to the local host */
	bcopy ((char *)&locaddr, (char *)&sin, sizeof (sin));
	sin.sin_port = port;

	sprintf (mbuf, "%c%c%s:%s", ESC, INQUIRE, login, user);

	for (tries = 0; tries < 5; tries++) {
		if ((r = sendit (mbuf, strlen (mbuf), sin)) <= 0) {
			if (Debug)
				printf ("\r\ncheck_invite: sendit returned %d.\r\n", r);
			continue;
		}
		buf[r] = '\0';
		if (Debug)
			printf ("check_invite: returned string is \"%s\"\r\n", buf+1);
		if (buf[2] == NAK)
			return ((char *) 0);
		return (strsave (buf+3));	/* skip over ESC I y */
		printf ("Trying to contact phone daemon.\r\n");
	}
	error (1, "Cannot contact local phone daemon.");
	return ((char *) 0);
}
