#ifndef lint
static char RCSid[] = "$Header: list.c,v 1.1 85/10/28 17:38:22 broome Exp $";
#endif

/*
 *  Routines for managing the list of pending calls, including
 *  creating and looking for invitations.
 */

/*
 * $Log:	list.c,v $
 * Revision 1.1  85/10/28  17:38:22  broome
 * Initial revision
 */

#include "../common.h"
#include "defs.h"
#include <sys/time.h>
#include <signal.h>
#include <stdio.h>



static int  requests = 0;              /* number of pending invitations */

/*
 *  Insert a request into the pending list.
 */

insert (inv)
INV    *inv;
{
	/* insert into top of list */
	if (invitations == NIL) {
		inv->next         = NIL;
		invitations       = inv;
	} else {
		inv->next         = invitations;
		invitations->prev = inv;
		invitations       = inv;
	}

	if (requests++ == 0)    /* need to set alarm interrupt */
		alarm (1);			/* so start up alarm */
}


/*
 *  Called on SIGALRM to process pending calls ---
 *  go through the list of pending invitations, removing any old
 *  ones, trying to ring the rest.
 */

ring ()
{
	register	INV   *inv;
	register	INV   *next;

	if (!requests)   /* no pending requests **/
		return;

	readutmp ();	/* reread /etc/utmp */

	for (inv = invitations; inv; inv = next) {
		next = inv->next;                	/* save the next one          */
		if (inv->rings++ == 0)				/* time to page this one ???  */
			dopage (inv);               	/* I guess so ...             */
		else if (inv->rings > 30)			/* more than five minutes old */
			delete (inv);
	}
	if (requests > 0)                        /* any requests left ???     */
		alarm (5);                           /* set the next alarm        */
#ifdef INET		  /* if running under inetd, exit when no more work to do */
	else
		exit (0);
#endif INETD
}


/*
 *  Page the given invitation and return a status message.
 *  Notice the incredible amount of indirection going on here -
 *  up to three (or is it four) levels !! Have to clean this up 
 *  when we get forwarding working properly.
 */

dopage (inv)
INV    *inv;
{
	char  rbuf[10];
	int   ret;
	char  *name;
	char  *tty;

	name = inv->callee;
	ret = _dopage (inv);

	sprintf (rbuf, "%c%c%c%s", ESC, CALLING, NAK, inv->id);

	if (ret == 0)		/* all looks to be good */
		return;

	if (ret == MESG_OFF)
		sprintf (buf, "%s%s@%s is refusing messages", rbuf, name, host);
	else if (ret == NOT_ON)
		sprintf (buf, "%s%s@%s is not logged in", rbuf, name, host);

	if ((tty = inv->tty) && *tty) {
		strcat (buf, " on ");
		strcat (buf, tty);
	}

	delete (inv);
	sendto (misc, buf, strlen (buf), 0, &inv->ctladdr, sizeof (inv->ctladdr));
}


/*
 *  Check to see if the named user is being invited by the right person.
 *  Returns a pointer to the invitation in question.
 *
 *  A wildcard "*" is acceptable as the caller name - this is 
 *  useful for answering machine programs.
 */

INV *
lookup (callee, caller)
char   *callee, *caller;
{
	register	INV  *inv;
	register	int  all = (eq (caller, "*"));

	for (inv = invitations; inv; inv = inv->next) {
		if (all || eq (inv->caller, caller))     /* caller match */
			if (eq (callee, inv->callee))        /* callee match */
				return (inv);
	}
	return (NIL);
}


/*
 *  The usual linked-list deletion routine, with a minor
 *  difference - instead of deallocating the space, we simply
 *  place the element on a free list for future use (LIFO form)
 */

delete (ptr)
INV *ptr;
{
	requests--;                      	/* decrement number pending  */
	if (ptr->prev)
		ptr->prev->next = ptr->next;	/* set previous's next pointer */ 
	else 
		invitations = ptr->next;

	if (ptr->next)
		ptr->next->prev = ptr->prev;	/* set next's previous pointer */
	
	ptr->next = freelist;				/* add on tail of free list */
	freelist = ptr;						/* and make this the top */
}
