/*
 *   Defines common to all the parts of the phone system.
 */


#ifndef		ESC
#define		ESC			'\033'		/* precedes all commands */
#endif

#define		ACK			'y'			/* good response code */
#define		NAK			'n'			/* not-so-good code   */

/*
 *   Commands sent from conversation daemon to client.
 */
 
#define		META		0200			/* high bit for command characters */
#define		ADDUSER		(01<<5)			/* add a user to the conversation  */
#define		DELUSER		(02<<5)			/* delete a user from conversation */
#define		UPDATE		(03<<5)			/* set screen update mode */

/*
 *   Commands sent from or master daemon to client.
 */

#define		MESSAGE		'M'				/* following is message text       */

/*
 *   Commands sent by client to conversation or master daemons.
 */

#define		ANSWER		'A'			/* he got the invite, will answer  */
#define		CALLING		'C'			/* daemon is calling the user      */
#define		PAGE		'P'			/* page a user                     */
#define		INQUIRE		'I'			/* inquire as to whether invited   */
#define		REINVITE	'R'			/* renew a request for paging      */
#define		DAEMON		'D'			/* create a daemon for me          */
#define		WHO			'W'			/* tell me who's on ...            */
#define		KILL		'K'			/* cause the daemon to exit        */

#ifndef PORT
#define		PORT	1167
#endif
