#include "../common.h"
#include "defs.h"
#include <netdb.h>
#include <utmp.h>
#include <sys/file.h>

/*
 *  Print out who is on the machine.
 *  If an argument is specified, only show occurrences of that user.
 */

who (argc, argv)
int  argc;
char *argv[];
{
	extern  int maxx;     /* max display line length   */
	int     found = 0;    /* found who we're looking for */
	int     utfd;         /* /etc/utmp file descriptor */
	int     len = 256;    /* length of current line    */
	int		ulen;         /* length of buf this user   */
	struct  utmp utmp;    /* one entry in /etc/utmp    */
	char    line[256];    /* line buffer               */
	char    buf[20];      /* and one entry buffer      */
	char	*host;
	struct	hostent	*hp, *gethostbyname();
	struct	sockaddr_in sin;

	if (argc == 1 && **argv == '@') {
		host = &argv[0][1];
		if (isdigit (*host))
			sin.sin_addr.s_addr = inet_addr (host);
		else if (hp = gethostbyname (host))
			bcopy ((char *)hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
		else {
			sprintf (buf, "who: unknown host: %s", host);
			message (buf);
		}
		sin.sin_port = port;
		sin.sin_family = AF_INET;
		sprintf (buf, "%c%c", ESC, WHO);
		if (sendto (ctl, buf, 2, 0, &sin, sizeof (sin)) < 0)
			error (0, "who: sendto");
		return;
	}
	if ((utfd = open ("/etc/utmp", O_RDONLY)) < 0) {
		message ("Can't open /etc/utmp!!!");
		return;
	}

	line[0] = '\0';

	while (read (utfd, (char *)&utmp, sizeof (struct utmp))) {
		if (utmp.ut_name[0] == '\0')
			continue;
		if (argc && strncmp (argv[0], utmp.ut_name, 8))
			continue;
		found++;
		sprintf (buf, " %.8s(%.5s)", utmp.ut_name, utmp.ut_line);
		ulen = strlen (buf);
		if (len + ulen + 2 < maxx) {        /* just add to current message */
			strcat (line, buf);
		} else {                            /* buf is too long - print line */
			message (line);
			len = Inverse ? 2 : 0;			/* kludge for inverse glitch */
			sprintf (line, "who:%s", buf);
		}
		len += ulen;                      /* add to total line length */
	}
	if (len)
		message (line);

	close (utfd);

	if (argc && !found)
		message ("<not logged on>");
}
