#include "defs.h"
#include <curses.h>
#undef   echo()
#undef   noecho()


/*
 *  See if char `c' is contained in string `s'. Returns 1 if true, 0 if not.
 */

any (c, s)
char c;
char *s;
{
	while (*s)
		if (c == *s++)
			return (1);
	return (0);
}


/*
 *  Send an error message to the user.  Much like perror().
 *  If fatal is non-zero, we will terminate with that status.
 */

error (fatal, mesg)
int    fatal;
char  *mesg;
{
	extern int   errno;
	extern char  *sys_errlist[];
	extern int   sys_nerr;
	char   buf[80];

	if (errno) {
		if (errno < sys_nerr) 
			sprintf (buf, "%s: %s", mesg, sys_errlist[errno]);
		else
			sprintf (buf, "%s: Error %d", mesg, errno);
	} else
		strcpy (buf, mesg);

	if (connected)	/* and have set up curses */
		putmessage (buf);
	else
		fprintf (stderr, "%s\r\n", buf);

	if (fatal) {
		cleanup ();
		printf ("\n\n");
		exit (fatal);
	}
}

/*
 *  User interface to the screen dump routine.
 */

dump (argc, argv)
int		argc;
char	*argv[];
{
	dodump (argc ? *argv : ".dump");
}


/*
 *  Do a screen dump to the named file.
 */

dodump (name)
char *name;
{
	FILE *fp;
	int  y, x;
	char buf[80];
	extern int connected;

	if (!connected)			/* take it as a normal interrupt */
		quit ();

	if ((fp = fopen (name, "w")) == (FILE *) 0) {
		(void) sprintf (buf, "Cannot create \"%s\" file", name);
		error (0, buf);
		return;
	}
	for (y = 0; y <= maxy; y++) {
		for (x = 0; x < maxx; x++) 
			(void) putc (stdscr->_y[y][x] & 0177, fp);
		(void) putc ('\n', fp);
	}
	(void) fclose (fp);
	(void) sprintf (buf, "Screen dump to \"%s\" complete.", name);
	putmessage (buf);
}



/*
 *  Move to the bottom line and exit.
 */

quit ()
{
	extern int did_screen;
	extern int childpid;

	if (did_screen)
		cleanup ();
	if (connected) 
		printf ("\nConnection closed. Exiting ...");
	printf ("\n");

	if (childpid)	/* clean up rather forcefully */
		kill (childpid, 9);

	exit (0);
}


/*
 *  Catch SIGWINCH and come here - just set a flag and return.
 */

sigwinch ()
{
	extern	int changed_size;
	changed_size = 1;
}



/*
 *   Chdir to the named directory, to $HOME if no args.
 */

cd (argc, argv)
int   argc;
char *argv[];
{
	char	*getenv();
	char	*dir;

	if (argc == 0) {		/* try to go home */
		if ((dir = getenv ("HOME")) == (char *) 0) {
			putmessage ("No HOME set!");
			return;
		}
	} else
		dir = argv[0];
	
	if (chdir (dir)) {
		sprintf (buf, "Cannot chdir to \"%s\"", dir);
		error (0, buf);
	}
}


/*
 *  Given a full pathname, return a pointer to the last part of the path.
 */

char *
basename (path)
char *path;
{
	char	*rindex();
	char	*p;

	if (p = rindex (path, '/'))
		return (p+1);
	return (path);
}

