#include "../common.h"
#include "defs.h"
#include <sys/time.h>
#include <signal.h>
#include <errno.h>

/*
 *  Ask the master daemon to give us its first-born child ...
 *  Returns the string that it gave us ...
 */

char *
getdaemon ()
{
	int    r;					/* number of chars read */
	char   mbuf[80];

	if (connected) {
		error (0, "getdaemon(): already connected!");
		return;
	}
	connected = 0;

	if (Debug)
		message ("Asking for a conversation daemon ...");

	mbuf[0] = ESC;
	mbuf[1] = DAEMON;

	for ( ;; ) {
		if ((r = sendit (mbuf, 2, locaddr)) < 0) {
			error (0, "could not get conversation daemon from local daemon");
			return ((char *) 0);
		}
		buf[r] = '\0';
		if (buf[2] == NAK) {
			sprintf (mbuf, "Daemon failed to fork: %s", buf+3);
			putmessage (mbuf);
		} else
			break;
		putmessage ("Trying to connect to conversation daemon.");
	}

	if (Debug)
		message (sprintf (mbuf, "Daemon address is %s", buf+3));

	return (strsave (buf+3));	/* skip ESC D y */
}
