#include "defs.h"


/*
 *  Routines to handle phone aliases, much like mail aliases.
 */

struct alias {
	char	*name;		/* name of alias */
	char	*real;		/* and what it expands to */
	struct	alias *next;
};

static	struct	alias	*aliases = (struct alias *) 0;


/*
 *  Set up an alias.
 */

alias (argc, argv)
int   argc;
char *argv[];
{
	struct	alias *ap;

	if (argc == 0) {		/* just show aliases */
		message ("Showing all aliases:");
		for (ap = aliases; ap; ap = ap->next) {
			sprintf (buf, "%s --> %s", ap->name, ap->real);
			message (buf);
		}
		message ("That's all!");
		return;
	}
	if (argc == 1) {
		putmessage ("alias: arg count must be 0 or 2!");
		return;
	}
	ap = (struct alias *) malloc (sizeof (struct alias));
	if (ap == (struct alias *) 0) {
		error (0, "alias: cannot allocate memory for alias");
		return;
	}
	ap->name = strsave (argv[0]);
	ap->real = strsave (argv[1]);

	ap->next = aliases;
	aliases = ap;
}



/*
 *  Expand an alias.  It copies the expansion into a buffer so 
 *  that the calling routines can munge it to their heart's content.
 */

char *
expalias (name)
char *name;
{
	register struct alias *ap;
	static   char   buf[128];

	for (ap = aliases; ap; ap = ap->next)
		if (strcmp (name, ap->name) == 0) {
			strcpy (buf, ap->real);
			return (buf);
		}
	return ((char *) 0);
}
